/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class TransportSetupTest {
    @Test
    public void testSetup() throws IOException {
        Setup setup = (Setup)AbstractSetup.readFromYaml(Setup.class, (InputStream)ResourceLoader.getResourceAsStream((String)"/test.yml", (ResourceResolver[])new ResourceResolver[]{ResourceLoader.MAVEN_RESOLVER}));
        Assert.assertNotNull((Object)setup);
        TransportSetup transport = setup.getTransport();
        Assert.assertNotNull((Object)transport);
        Assert.assertEquals((Object)"me.de", (Object)transport.getHost());
        Assert.assertEquals((long)1234L, (long)transport.getPort());
        TransportSetup copy = transport.copy();
        Assert.assertNotNull((Object)copy);
        Assert.assertEquals((Object)"me.de", (Object)copy.getHost());
        Assert.assertEquals((long)1234L, (long)copy.getPort());
        TransportParameter param = transport.createParameter();
        Assert.assertNotNull((Object)param);
        Assert.assertEquals((Object)"me.de", (Object)param.getHost());
        Assert.assertEquals((long)1234L, (long)param.getPort());
    }

    public static class Setup {
        private TransportSetup transport;

        public TransportSetup getTransport() {
            return this.transport;
        }

        public void setTransport(TransportSetup transport) {
            this.transport = transport;
        }
    }
}

