/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.mqttv5.PahoMqttV5TransportConnectorFactoryDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import org.junit.Test;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8SJavaProxy;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8STLS;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;

public class WorkerMqttJavaK8SProxy {
    private static int localPort = 6443;
    private static int mqttPort = 9911;
    private static String serverIP = "Empty";
    private static String serverPort = "9922";
    private static boolean tlsCheck = false;
    private static ArrayList<ServerSocket> serverSocketList = new ArrayList();
    private static ArrayList<TransportK8SJavaProxy> k8SJavaProxyList = new ArrayList();

    public static int getLocalPort() {
        return localPort;
    }

    public static void setLocalPort(int localPort) {
        WorkerMqttJavaK8SProxy.localPort = localPort;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static void setServerIP(String serverIP) {
        WorkerMqttJavaK8SProxy.serverIP = serverIP;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static void setServerPort(String serverPort) {
        WorkerMqttJavaK8SProxy.serverPort = serverPort;
    }

    public int getMqttPort() {
        return mqttPort;
    }

    public void setMqttPort(int mqttPort) {
        WorkerMqttJavaK8SProxy.mqttPort = mqttPort;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            serverIP = args[0];
            System.out.println("Api Server IP:" + serverIP);
        } else {
            System.out.println("No Api Server IP passed");
        }
        if (args.length > 1) {
            tlsCheck = Boolean.parseBoolean(args[1]);
            if (tlsCheck) {
                System.out.println("Security option Enabled");
            } else {
                System.out.println("Security option Disabled");
            }
        } else {
            System.out.println("No security option passed, default false");
        }
        Thread requestThread = new Thread(){

            @Override
            public void run() {
                try {
                    TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)PahoMqttV5TransportConnectorFactoryDescriptor.MAIN);
                    AbstractTransportConnectorTest.TransportParameterConfigurer configurer = null;
                    if (tlsCheck) {
                        configurer = new AbstractTransportConnectorTest.TransportParameterConfigurer(){

                            public void configure(TransportParameter.TransportParameterBuilder builder) {
                                builder.setKeystoreKey("mqttKeyStore");
                                builder.setKeyAlias("qpid");
                                builder.setActionTimeout(3000);
                            }
                        };
                    }
                    TransportK8STLS transportK8STLS = new TransportK8STLS(tlsCheck, configurer);
                    TransportK8SJavaProxy mqttK8SJavaProxy = new TransportK8SJavaProxy(ProxyType.WorkerProxy, serverIP, serverPort, transportK8STLS);
                    k8SJavaProxyList.add(mqttK8SJavaProxy);
                    WorkerMqttJavaK8SProxy.startMultiThreaded((K8SJavaProxy)mqttK8SJavaProxy, localPort);
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
                    System.err.println("Exception in the starting the multi-threads method");
                    e.printStackTrace();
                }
            }
        };
        requestThread.start();
        while (true) {
            if (new File("/tmp/EndClientRun.k8s").exists()) {
                try {
                    k8SJavaProxyList.get(0).getNormalcl1().disconnect();
                    serverSocketList.get(0).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            TimeUtils.sleep((int)1);
        }
    }

    @Test(timeout=100000L)
    public void mainTest() {
        tlsCheck = Boolean.valueOf(System.getProperty("tlsCheck"));
        try {
            TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)PahoMqttV5TransportConnectorFactoryDescriptor.MAIN);
            AbstractTransportConnectorTest.TransportParameterConfigurer configurer = null;
            if (tlsCheck) {
                configurer = new AbstractTransportConnectorTest.TransportParameterConfigurer(){

                    public void configure(TransportParameter.TransportParameterBuilder builder) {
                        builder.setKeystoreKey("mqttKeyStore");
                        builder.setKeyAlias("qpid");
                        builder.setActionTimeout(3000);
                    }
                };
            }
            TransportK8STLS transportK8STLS = new TransportK8STLS(tlsCheck, configurer);
            TransportK8SJavaProxy mqttK8SJavaProxy = new TransportK8SJavaProxy(ProxyType.WorkerProxy, serverIP, serverPort, transportK8STLS);
            WorkerMqttJavaK8SProxy.startMultiThreaded((K8SJavaProxy)mqttK8SJavaProxy, localPort);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            System.err.println("Exception in the starting the multi-threads method");
            e.printStackTrace();
        }
        while (true) {
            TimeUtils.sleep((int)1);
        }
    }

    public static void startMultiThreaded(final K8SJavaProxy mqttK8SJavaProxy, int localPort) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        if (new File("/tmp/EndClientRun.k8s").exists()) {
            System.out.println("/tmp/EndClientRun.k8s is exist and stop the Client");
            return;
        }
        ServerSocket serverSocket = mqttK8SJavaProxy.getServerSocket(localPort, null, null, null, tlsCheck);
        serverSocketList.add(serverSocket);
        System.out.println("Started multi-threaded server at localhost port " + localPort);
        File file = new File("ClientReady.k8s");
        file.createNewFile();
        while (true) {
            final Socket socket = serverSocket.accept();
            Thread requestThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream reader = null;
                    FilterOutputStream writer = null;
                    try {
                        K8SRequest request;
                        do {
                            reader = socket.getInputStream();
                            writer = new BufferedOutputStream(socket.getOutputStream());
                            byte[] requestByte = mqttK8SJavaProxy.extractK8SRequestByte(reader);
                            if (requestByte == null) break;
                            request = mqttK8SJavaProxy.createK8SRequest(requestByte);
                            byte[] responseString = mqttK8SJavaProxy.sendK8SRequest((BufferedOutputStream)writer, request);
                            if (responseString.length == 0) {
                                break;
                            }
                            writer.write(responseString);
                            ((BufferedOutputStream)writer).flush();
                        } while (!request.getPath().contains("&watch=true"));
                    }
                    catch (SocketException e) {
                        if (e.getMessage().contentEquals("Socket input is already shutdown")) {
                            System.out.println(e.getMessage());
                        } else {
                            System.err.println("SocketException while creating response");
                            e.printStackTrace();
                        }
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        System.err.println("Exception while creating response");
                        e.printStackTrace();
                        System.out.println("socket thread ends Throwable");
                    }
                    finally {
                        try {
                            writer.close();
                            reader.close();
                        }
                        catch (IOException e) {
                            System.err.println("Could not close the streams");
                            e.printStackTrace();
                        }
                    }
                }
            };
            requestThread.start();
        }
    }
}

