/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.SSLUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.Arrays;

public abstract class AbstractK8SJavaProxy
implements K8SJavaProxy {
    private ProxyType proxyType;
    private String serverAddress;
    private OkHttpClient okHttpClient;
    private ApiClient client;
    private File confFile;

    public AbstractK8SJavaProxy(ProxyType proxyType, String serverAddress) {
        this.proxyType = proxyType;
        this.serverAddress = serverAddress;
        if (proxyType.equals((Object)ProxyType.MasterProxy)) {
            this.confFile = new File("admin.conf");
            try {
                this.client = Config.fromConfig((String)this.confFile.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Configuration.setDefaultApiClient((ApiClient)this.client);
            this.okHttpClient = this.client.getHttpClient();
        }
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(ProxyType proxyType) {
        this.proxyType = proxyType;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public ServerSocket getServerSocket(int localPort, String certificatePath, String keyPath, String algo, boolean tlsCheck) throws IOException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InvalidKeySpecException, KeyManagementException {
        if (this.proxyType.equals((Object)ProxyType.MasterProxy)) {
            if (tlsCheck) {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream("./src/test/resources/keystore.jks"), "a1234567".toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, "a1234567".toCharArray());
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(kmf.getKeyManagers(), null, null);
                SSLServerSocketFactory ssf = sc.getServerSocketFactory();
                SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket(localPort);
                return serverSocket;
            }
            return new ServerSocket(localPort);
        }
        String keyFile = null;
        String certificateFile = null;
        String algorithm = null;
        if (certificatePath == null || keyPath == null || algo == null) {
            keyFile = "apiserver.key";
            certificateFile = "apiserver.crt";
            algorithm = "RSA";
        }
        byte[] certificate = Files.readAllBytes(Paths.get(certificateFile, new String[0]));
        byte[] key = Files.readAllBytes(Paths.get(keyFile, new String[0]));
        KeyManager[] keyManagers = SSLUtils.keyManagers((byte[])certificate, (byte[])key, (String)algorithm, (String)"", null, null);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, null, null);
        ServerSocket serverSocket = sslContext.getServerSocketFactory().createServerSocket(localPort);
        return serverSocket;
    }

    @Override
    public byte[] extractK8SRequestByte(InputStream reader) throws IOException {
        byte[] request = new byte[4096];
        int bytesRead = 0;
        bytesRead = reader.read(request);
        if (bytesRead == -1) {
            return null;
        }
        byte[] requestByte = new byte[bytesRead];
        System.arraycopy(request, 0, requestByte, 0, bytesRead);
        String requestFirstString = new String(requestByte);
        int requestLength = 0;
        boolean isHeader = true;
        int headerSize = 0;
        for (String string : requestFirstString.split("\r\n")) {
            if (string.toUpperCase().contains("CONTENT-LENGTH")) {
                requestLength = Integer.parseInt(string.substring(16));
            }
            if (!isHeader) continue;
            if (string.getBytes().length > 0) {
                headerSize = headerSize + string.getBytes().length + "\r\n".getBytes().length;
                continue;
            }
            headerSize = headerSize + string.getBytes().length + "\r\n".getBytes().length;
            isHeader = false;
        }
        while (requestLength > bytesRead - headerSize) {
            bytesRead = reader.read(request);
            byte[] tempRequestByte = new byte[bytesRead + requestByte.length];
            System.arraycopy(requestByte, 0, tempRequestByte, 0, requestByte.length);
            System.arraycopy(request, 0, tempRequestByte, requestByte.length, bytesRead);
            bytesRead = tempRequestByte.length;
            requestByte = tempRequestByte;
        }
        return requestByte;
    }

    @Override
    public K8SRequest createK8SRequest(byte[] requestByte) {
        String requestString = new String(requestByte);
        K8SRequest request = new K8SRequest();
        request.setRequestByte(requestByte);
        HashMap<String, String[]> requestHeaders = new HashMap<String, String[]>();
        int requestLength = 0;
        int count = 0;
        for (String string : requestString.split("\r\n")) {
            if (string.equals("")) break;
            if (count == 0) {
                String[] requestLine = string.split(" ");
                request.setMethod(requestLine[0]);
                request.setPath(requestLine[1]);
                request.setProtocol(requestLine[2]);
                ++count;
                continue;
            }
            if (string.contains("Host")) continue;
            if (string.toUpperCase().contains("CONTENT-LENGTH")) {
                requestLength = Integer.parseInt(string.substring(16));
            }
            String key = string.substring(0, string.indexOf(":"));
            String[] header = new String[]{key, string.substring(string.indexOf(":") + 2)};
            requestHeaders.put(key.toUpperCase(), header);
        }
        request.setHeaders(requestHeaders);
        if (!request.getMethod().equals("GET")) {
            byte[] payloadByte = new byte[requestLength];
            int startBodyByte = requestByte.length - requestLength;
            System.arraycopy(requestByte, startBodyByte, payloadByte, 0, requestLength);
            request.setPayload(payloadByte);
        }
        return request;
    }

    @Override
    public byte[] sendK8SRequest(BufferedOutputStream writer, K8SRequest request) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException {
        byte[] response = null;
        if (this.getProxyType() == ProxyType.MasterProxy) {
            response = this.executeK8SJavaClientRequest(writer, request);
        } else if (request.getMethod().equals("GET")) {
            response = this.executeK8SGet(writer, request);
        } else if (request.getMethod().equals("POST")) {
            response = this.executeK8SPost(request);
        } else if (request.getMethod().equals("PUT")) {
            response = this.executeK8SPut(request);
        } else if (request.getMethod().equals("PATCH")) {
            response = this.executeK8SPatch(request);
        } else if (request.getMethod().equals("DELETE")) {
            response = this.executeK8SDelete(request);
        }
        return response;
    }

    @Override
    public byte[] executeK8SJavaClientRequest(BufferedOutputStream writer, K8SRequest request) throws IOException {
        String url = this.serverAddress + request.getPath();
        Request javaK8SRequest = null;
        Request.Builder requestBuilder = null;
        if (request.getMethod().equals("GET")) {
            requestBuilder = new Request.Builder().url(url);
            for (String[] value : request.getHeaders().values()) {
                requestBuilder.addHeader(value[0], value[1]);
            }
            javaK8SRequest = requestBuilder.build();
        } else {
            requestBuilder = new Request.Builder().url(url);
            for (String[] value : request.getHeaders().values()) {
                requestBuilder.addHeader(value[0], value[1]);
            }
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)request.getHeaders().get("CONTENT-TYPE")[1]), (byte[])request.getPayload());
            requestBuilder.method(request.getMethod(), requestBody);
            javaK8SRequest = requestBuilder.build();
        }
        byte[] formattedResponse = null;
        if (request.getPath().contains("&watch=true")) {
            OkHttpClient client11 = this.client.getHttpClient();
            Response response = client11.newCall(javaK8SRequest).execute();
            formattedResponse = this.formatWatchK8SResponse(writer, request, response);
        } else {
            Response response = this.okHttpClient.newCall(javaK8SRequest).execute();
            formattedResponse = this.formatK8SResponse(request, response);
        }
        if (formattedResponse == null || formattedResponse.length == 0) {
            System.out.println("Empty response k8s execute");
        }
        return formattedResponse;
    }

    @Override
    public Response executeWatchK8SJavaClientRequest(K8SRequest request) throws IOException {
        OkHttpClient client11 = this.client.getHttpClient();
        String url = this.getServerAddress() + request.getPath();
        Request javaK8SRequest = null;
        Request.Builder requestBuilder = null;
        if (request.getMethod().equals("GET")) {
            requestBuilder = new Request.Builder().url(url);
            for (String[] value : request.getHeaders().values()) {
                requestBuilder.addHeader(value[0], value[1]);
            }
            javaK8SRequest = requestBuilder.build();
        } else {
            requestBuilder = new Request.Builder().url(url);
            for (String[] value : request.getHeaders().values()) {
                requestBuilder.addHeader(value[0], value[1]);
            }
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)request.getHeaders().get("CONTENT-TYPE")[1]), (byte[])request.getPayload());
            requestBuilder.method(request.getMethod(), requestBody);
            javaK8SRequest = requestBuilder.build();
        }
        Response response = client11.newCall(javaK8SRequest).execute();
        return response;
    }

    @Override
    public byte[] formatK8SResponse(K8SRequest request, HttpResponse httpResponse) throws ParseException, IOException {
        String formattedResponse = request.getProtocol() + " " + httpResponse.getStatusLine().getStatusCode() + "\r\n";
        for (Header header : httpResponse.getAllHeaders()) {
            formattedResponse = formattedResponse + header.toString() + "\r\n";
        }
        byte[] formattedResponsebyte = (formattedResponse + "\r\n").getBytes();
        byte[] responsebyte = null;
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            byte[] result = EntityUtils.toByteArray((HttpEntity)entity);
            if (formattedResponse.toUpperCase().contains("TRANSFER-ENCODING: CHUNKED")) {
                byte[] firstPart = (Integer.toHexString(result.length) + "\r\n").getBytes();
                byte[] secondPart = "\r\n0\r\n\r\n".getBytes();
                result = Arrays.concatenate((byte[])firstPart, (byte[])result);
                result = Arrays.concatenate((byte[])result, (byte[])secondPart);
            }
            responsebyte = Arrays.concatenate((byte[])formattedResponsebyte, (byte[])result);
        }
        return responsebyte;
    }

    @Override
    public byte[] formatWatchK8SResponse(BufferedOutputStream writer, K8SRequest request, HttpResponse httpResponse) throws ParseException, IOException {
        byte[] firstPart;
        Object formattedResponse = request.getProtocol() + " " + httpResponse.getStatusLine().getStatusCode() + "\r\n";
        for (Header header : httpResponse.getAllHeaders()) {
            formattedResponse = (String)formattedResponse + header.toString() + "\r\n";
        }
        byte[] formattedResponsebyte = ((String)formattedResponse + "\r\n").getBytes();
        byte[] responseBody = new byte[4096];
        int responseSize = 0;
        responseSize = httpResponse.getEntity().getContent().read(responseBody);
        if (responseSize != -1) {
            if (request.getPath().contains("/api/v1/namespaces/services")) {
                System.out.println("here");
            }
            responseBody = Arrays.copyOf((byte[])responseBody, (int)responseSize);
            firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
            responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
            responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
            responseBody = Arrays.concatenate((byte[])formattedResponsebyte, (byte[])responseBody);
            writer.write(responseBody);
            writer.flush();
            responseBody = new byte[4096];
        } else {
            return ((String)formattedResponse + "\r\n0\r\n\r\n").getBytes();
        }
        while ((responseSize = httpResponse.getEntity().getContent().read(responseBody)) != -1) {
            responseBody = Arrays.copyOf((byte[])responseBody, (int)responseSize);
            firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
            responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
            responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
            writer.write(responseBody);
            writer.flush();
            responseBody = new byte[4096];
        }
        formattedResponse = "0\r\n\r\n";
        return ((String)formattedResponse).getBytes();
    }

    @Override
    public byte[] formatK8SResponse(K8SRequest request, Response response) throws IOException {
        byte[] responseBody = response.body().bytes();
        String formattedResponse = request.getProtocol() + " " + response.code() + " " + response.message() + "\r\n" + response.headers().toString() + "\r\n";
        byte[] formattedResponsebyte = formattedResponse.getBytes();
        if (formattedResponse.toUpperCase().contains("TRANSFER-ENCODING: CHUNKED")) {
            byte[] firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
            byte[] secondPart = "\r\n0\r\n\r\n".getBytes();
            responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
            responseBody = Arrays.concatenate((byte[])responseBody, (byte[])secondPart);
        }
        response.body().close();
        byte[] responsebyte = Arrays.concatenate((byte[])formattedResponsebyte, (byte[])responseBody);
        return responsebyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] formatWatchK8SResponse(BufferedOutputStream writer, K8SRequest request, Response response) throws IOException {
        byte[] responseBody = new byte[]{};
        Object formattedResponse = request.getProtocol() + " " + response.code() + " " + response.message() + "\r\n" + response.headers().toString() + "\r\n";
        byte[] formattedResponsebyte = ((String)formattedResponse).getBytes();
        try {
            byte[] firstPart;
            Buffer buffer;
            if (!response.body().source().exhausted()) {
                if (((String)formattedResponse).contains("application/vnd.kubernetes.protobuf")) {
                    buffer = new Buffer();
                    response.body().source().read(buffer, 4096L);
                    responseBody = buffer.readByteArray();
                } else {
                    long count = response.body().source().indexOf((byte)10);
                    responseBody = response.body().source().readByteArray(count + 1L);
                }
                firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
                responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
                responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
                responseBody = Arrays.concatenate((byte[])formattedResponsebyte, (byte[])responseBody);
                writer.write(responseBody);
                writer.flush();
            }
            while (!response.body().source().exhausted()) {
                if (((String)formattedResponse).contains("application/vnd.kubernetes.protobuf")) {
                    buffer = new Buffer();
                    response.body().source().read(buffer, 4096L);
                    responseBody = buffer.readByteArray();
                } else {
                    long count = response.body().source().indexOf((byte)10);
                    responseBody = response.body().source().readByteArray(count + 1L);
                }
                firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
                responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
                responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
                writer.write(responseBody);
                writer.flush();
            }
        }
        catch (SocketTimeoutException e) {
            if (e.getMessage().contentEquals("timeout") || e.getMessage().contentEquals("Read timed out")) {
                String timeout = "timeout";
                System.out.println(timeout);
            } else {
                e.printStackTrace();
            }
        }
        finally {
            response.body().close();
        }
        formattedResponse = responseBody.length != 0 ? "0\r\n\r\n" : (String)formattedResponse + "0\r\n\r\n";
        return ((String)formattedResponse).getBytes();
    }

    protected static String getServerAddress(ProxyType proxyType, String serverIP, String serverPort, boolean tlsCheck) {
        if (proxyType == ProxyType.MasterProxy || tlsCheck) {
            return "https://" + serverIP + ":" + serverPort;
        }
        return "http://" + serverIP + ":" + serverPort;
    }
}

