/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;

public class MasterAasCreator {
    public static final String URN_AAS = "urn:::AAS:::MasterK8SAas#";
    public static final String AAS_NAME = "MasterK8SAas";
    public static final String AAS_SUBMODEL_NAME = "MasterK8SAasService";
    public static final String AAS_SUBMODEL_PROPERTY_NAME = "name";
    public static final String AAS_SUBMODEL_PROPERTY_VERSION = "version";
    public static final String AAS_SUBMODEL_PROPERTY_DESCRIPTION = "description";
    public static final String AAS_SUBMODEL_OPERATION_SEND_TO_K8S = "sendToK8S";
    public static final String AAS_SUBMODEL_OPERATION_SEND_WATCH_TO_K8S = "sendWatchToK8S";
    public static final String VAB_PROPERTY_NAME = "name";
    public static final String VAB_PROPERTY_VERSION = "version";
    public static final String VAB_PROPERTY_DESCRIPTION = "description";
    public static final String VAB_OPERATION_SEND_TO_K8S = "sendToK8S";
    public static final String VAB_OPERATION_SEND_WATCH_TO_K8S = "sendWatchToK8S";

    public static Aas createAas(ServerAddress addr) {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator iCreator = factory.createInvocablesCreator((SetupSpec)new BasicSetupSpec("", addr.getHost(), addr.getPort()));
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(AAS_NAME, URN_AAS);
        Submodel.SubmodelBuilder smBuilder = aasBuilder.createSubmodelBuilder(AAS_SUBMODEL_NAME, null);
        smBuilder.createPropertyBuilder("name").setType(Type.STRING).bind(iCreator.createGetter("name"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("version").setType(Type.STRING).bind(iCreator.createGetter("version"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createPropertyBuilder("description").setType(Type.STRING).bind(iCreator.createGetter("description"), InvocablesCreator.READ_ONLY).build();
        smBuilder.createOperationBuilder("sendToK8S").setInvocable(iCreator.createInvocable("sendToK8S")).addInputVariable("M1", Type.STRING).addOutputVariable("R1", Type.STRING).build();
        smBuilder.createOperationBuilder("sendWatchToK8S").setInvocable(iCreator.createInvocable("sendWatchToK8S")).addInputVariable("M1", Type.STRING).addOutputVariable("R1", Type.STRING).build();
        smBuilder.build();
        return (Aas)aasBuilder.build();
    }
}

