/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class ContainerManagerTest {
    @Test(timeout=60000L)
    public void testContainerManager() throws ExecutionException, URISyntaxException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        URI dummy = new URI("file:///dummy/dummy.txt");
        ContainerManager mgr = EcsFactory.getContainerManager();
        Assert.assertNotNull((Object)mgr);
        String id = mgr.addContainer(dummy);
        Assert.assertNotNull((Object)id);
        Assert.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        ContainerDescriptor cnt = mgr.getContainer("");
        Assert.assertNull((Object)cnt);
        cnt = mgr.getContainer(id);
        Assert.assertNotNull((Object)cnt);
        Assert.assertEquals((Object)id, (Object)cnt.getId());
        Assert.assertNotNull((Object)cnt.getName());
        Assert.assertEquals((Object)ContainerState.AVAILABLE, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.AVAILABLE, (Object)mgr.getState(id));
        Assert.assertNotNull((Object)cnt.getVersion());
        Assert.assertTrue((boolean)mgr.getContainers().contains(cnt));
        Assert.assertTrue((boolean)mgr.getIds().contains(id));
        try {
            mgr.startContainer("");
            Assert.fail((String)"No exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        mgr.startContainer(id);
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)mgr.getState(id));
        mgr.updateContainer(id, dummy);
        mgr.stopContainer(id);
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)mgr.getState(id));
        mgr.startContainer(id);
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)mgr.getState(id));
        try {
            mgr.undeployContainer(id);
            Assert.fail((String)"No exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        mgr.stopContainer(id);
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)mgr.getState(id));
        mgr.undeployContainer(id);
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)mgr.getState(id));
        id = mgr.addContainer(dummy);
        cnt = mgr.getContainer(id);
        mgr.startContainer(id);
        mgr.migrateContainer(id, "other");
        if (ContainerState.STOPPED == cnt.getState()) {
            mgr.undeployContainer(id);
        }
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)cnt.getState());
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)mgr.getState(id));
        Assert.assertFalse((boolean)mgr.getContainers().contains(cnt));
        Assert.assertTrue((mgr.getContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)mgr.getIds().contains(id));
        Assert.assertTrue((mgr.getIds().size() > 0 ? 1 : 0) != 0);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }
}

