/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistrationResponse;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryClient;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistryClientFactory;
import de.iip_ecosphere.platform.ecsRuntime.ssh.RemoteAccessServer;
import de.iip_ecosphere.platform.ecsRuntime.ssh.RemoteAccessServerFactory;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class DeviceManagement {
    private static RemoteAccessServer remoteAccessServer;

    public static DeviceRegistryClient getRegistryClient() throws IOException {
        return DeviceRegistryClientFactory.createDeviceRegistryClient();
    }

    public static RemoteAccessServer getRemoteAccessServer() {
        if (null == remoteAccessServer) {
            remoteAccessServer = RemoteAccessServerFactory.create();
        }
        return remoteAccessServer;
    }

    public static DeviceRegistrationResponse addDevice(boolean onboard) throws ExecutionException {
        DeviceRegistrationResponse result = null;
        DeviceRegistryClient registryClient = DeviceRegistryClientFactory.createDeviceRegistryClient();
        SubmodelElementCollection device = registryClient.getDevice(Id.getDeviceIdAas());
        if (null == device) {
            if (onboard) {
                String ip = NetUtils.getOwnIP((String)"");
                result = registryClient.addDevice(Id.getDeviceIdAas(), ip);
                Transport.sendResourceStatus((ActionType)ActionTypes.ADDED, (String[])new String[0]);
            } else {
                throw new ExecutionException("This decvice was not onboarded before. Stopping.", null);
            }
        }
        RemoteAccessServer remoteAccessServer = DeviceManagement.getRemoteAccessServer();
        remoteAccessServer.start();
        return result;
    }

    public static void removeDevice(boolean offboard) throws ExecutionException {
        block4: {
            try {
                DeviceRegistryClient registryClient = DeviceManagement.getRegistryClient();
                SubmodelElementCollection device = registryClient.getDevice(Id.getDeviceIdAas());
                if (null != device) {
                    if (offboard) {
                        registryClient.removeDevice(Id.getDeviceIdAas());
                        Transport.sendResourceStatus((ActionType)ActionTypes.REMOVED, (String[])new String[0]);
                    }
                    break block4;
                }
                throw new ExecutionException("Device was not registered.", null);
            }
            catch (IOException | ExecutionException e) {
                throw new ExecutionException("Removing Device: " + e.getMessage(), null);
            }
        }
    }
}

