/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.deviceMgt.Credentials;
import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProvider;
import de.iip_ecosphere.platform.ecsRuntime.ssh.RemoteAccessServerFactory;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.SystemMetrics;
import de.iip_ecosphere.platform.support.metrics.SystemMetricsFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class EcsAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "resources";
    public static final String NAME_PROP_CSYS_NAME = "containerSystemName";
    public static final String NAME_PROP_CSYS_VERSION = "containerSystemVersion";
    public static final String NAME_COLL_CONTAINERS = "containers";
    public static final String NAME_PROP_ID = "id";
    public static final String NAME_PROP_NAME = "name";
    public static final String NAME_PROP_VERSION = "version";
    public static final String NAME_PROP_STATE = "state";
    public static final String NAME_PROP_RESOURCE = "resource";
    public static final String NAME_PROP_RUNTIME_NAME = "runtimeName";
    public static final String NAME_PROP_RUNTIME_VERSION = "runtimeVersion";
    public static final String NAME_PROP_DEVICE_AAS = "deviceAas";
    public static final String NAME_PROP_OPERATING_SYSTEM = "OS";
    public static final String NAME_PROP_CPU_ARCHITECTURE = "CPU_Architecture";
    public static final String NAME_PROP_CPU_CAPACITY = "CPU_Capacity";
    public static final String NAME_PROP_GPU_CAPACITY = "GPU_Capacity";
    public static final String NAME_OP_GET_STATE = "getState";
    public static final String NAME_OP_CONTAINER_ADD = "addContainer";
    public static final String NAME_OP_CONTAINER_GETID = "getId";
    public static final String NAME_OP_CONTAINER_ADD_TASK = "addContainerAsTask";
    public static final String NAME_OP_CONTAINER_UNDEPLOY = "undeployContainer";
    public static final String NAME_OP_CONTAINER_UPDATE = "updateContainer";
    public static final String NAME_OP_CONTAINER_MIGRATE = "migrateContainer";
    public static final String NAME_OP_CONTAINER_STOP = "stopContainer";
    public static final String NAME_OP_CONTAINER_STOP_TASK = "stopContainerAsTask";
    public static final String NAME_OP_CONTAINER_START = "startContainer";
    public static final String NAME_OP_CONTAINER_START_TASK = "startContainerAsTask";
    public static final String NAME_OP_CREATE_REMOTE_CONNECTION_CREDENTIALS = "createRemoteConnectionCredentials";
    private static boolean enabled = false;

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        AuthenticationDescriptor aDesc = this.getSubmodelAuthentication();
        ContainerManager mgr = EcsFactory.getContainerManager();
        Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)NAME_SUBMODEL);
        smB.createSubmodelElementCollectionBuilder(NAME_COLL_CONTAINERS).build();
        SubmodelElementCollection.SubmodelElementCollectionBuilder jB = smB.createSubmodelElementCollectionBuilder(Id.getDeviceIdAas());
        MetricsAasConstructor.addProviderMetricsToAasSubmodel((SubmodelElementContainerBuilder)jB, null, (String)"EcsMetrics", (String)Id.getDeviceId(), (TransportSetup)EcsFactory.getSetup().getTransport());
        jB.createPropertyBuilder(NAME_PROP_CSYS_NAME).setValue(Type.STRING, (Object)(null == mgr ? "none" : mgr.getContainerSystemName())).setSemanticId("irdi:0173-1#02-AAO247#002").build(aDesc);
        SystemMetrics sysM = SystemMetricsFactory.getSystemMetrics();
        jB.createPropertyBuilder(NAME_PROP_OPERATING_SYSTEM).setValue(Type.STRING, (Object)sysM.getOsName()).setSemanticId("irdi:0173-1#02-AAO247#002").build(aDesc);
        jB.createPropertyBuilder(NAME_PROP_CPU_ARCHITECTURE).setValue(Type.STRING, (Object)sysM.getOsArch()).build(aDesc);
        jB.createPropertyBuilder(NAME_PROP_CPU_CAPACITY).setValue(Type.INTEGER, (Object)sysM.getNumCpuCores()).build(aDesc);
        jB.createPropertyBuilder(NAME_PROP_GPU_CAPACITY).setValue(Type.INTEGER, (Object)sysM.getNumGpuCores()).build(aDesc);
        jB.createPropertyBuilder(NAME_PROP_RUNTIME_NAME).setValue(Type.STRING, (Object)(null == mgr ? "none" : mgr.getRuntimeName())).setSemanticId("irdi:0173-1#02-AAO247#002").build(aDesc);
        jB.createPropertyBuilder(NAME_PROP_RUNTIME_VERSION).setValue(Type.STRING, (Object)(null == mgr ? "?" : mgr.getVersion())).setSemanticId("irdi:0173-1#02-AAM737#002").build(aDesc);
        jB.createPropertyBuilder(NAME_PROP_DEVICE_AAS).setValue(Type.STRING, (Object)DeviceAasProvider.getInstance().getDeviceAasAddress()).build(aDesc);
        jB.createOperationBuilder(NAME_OP_CREATE_REMOTE_CONNECTION_CREDENTIALS).setInvocable(iCreator.createInvocable(EcsAas.getQName(NAME_OP_CREATE_REMOTE_CONNECTION_CREDENTIALS))).build(Type.STRING, aDesc);
        if (null != mgr) {
            jB.createPropertyBuilder(NAME_PROP_CSYS_VERSION).setValue(Type.STRING, (Object)mgr.getContainerSystemVersion()).setSemanticId("irdi:0173-1#02-AAM737#002").build();
            this.createIdOp(jB, NAME_OP_CONTAINER_START, iCreator, new String[0]);
            this.createIdOp(jB, NAME_OP_CONTAINER_START_TASK, iCreator, "taskId");
            this.createIdOp(jB, NAME_OP_CONTAINER_MIGRATE, iCreator, "location");
            this.createIdOp(jB, NAME_OP_CONTAINER_UPDATE, iCreator, "location");
            this.createIdOp(jB, NAME_OP_CONTAINER_UNDEPLOY, iCreator, new String[0]);
            this.createIdOp(jB, NAME_OP_CONTAINER_STOP, iCreator, new String[0]);
            this.createIdOp(jB, NAME_OP_CONTAINER_STOP_TASK, iCreator, "taskId");
            this.createIdOp(jB, NAME_OP_GET_STATE, iCreator, new String[0]);
            jB.createOperationBuilder(NAME_OP_CONTAINER_ADD).setInvocable(iCreator.createInvocable(EcsAas.getQName(NAME_OP_CONTAINER_ADD))).addInputVariable("url", Type.STRING).build(Type.STRING, aDesc);
            jB.createOperationBuilder(NAME_OP_CONTAINER_GETID).setInvocable(iCreator.createInvocable(EcsAas.getQName(NAME_OP_CONTAINER_GETID))).addInputVariable("url", Type.STRING).build(Type.STRING, aDesc);
            jB.createOperationBuilder(NAME_OP_CONTAINER_ADD_TASK).setInvocable(iCreator.createInvocable(EcsAas.getQName(NAME_OP_CONTAINER_ADD_TASK))).addInputVariable("url", Type.STRING).addInputVariable("taskId", Type.STRING).build(Type.STRING, aDesc);
        }
        jB.build();
        if (null != mgr) {
            for (ContainerDescriptor containerDescriptor : mgr.getContainers()) {
                EcsAas.addContainer(smB, containerDescriptor);
            }
        }
        smB.defer();
        return null;
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
        if (null != EcsFactory.getContainerManager()) {
            this.contributeToImpl(sBuilder);
        }
    }

    private void contributeToImpl(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_START), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().startContainer(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_START_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().startContainer(AasUtils.readString((Object[])p));
            return null;
        }, p -> AasUtils.readString((Object[])p, (int)1)));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_MIGRATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().migrateContainer(AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1));
            return null;
        }));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_UPDATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().updateContainer(AasUtils.readString((Object[])p), AasUtils.readUri((Object[])p, (int)1, (URI)AasUtils.EMPTY_URI));
            return null;
        }));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_UNDEPLOY), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().undeployContainer(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_STOP), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().stopContainer(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_STOP_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            EcsFactory.getContainerManager().stopContainer(AasUtils.readString((Object[])p));
            return null;
        }, p -> AasUtils.readString((Object[])p, (int)1)));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_GET_STATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> EcsFactory.getContainerManager().getState(AasUtils.readString((Object[])p))));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_ADD), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> EcsFactory.getContainerManager().addContainer(AasUtils.readUri((Object[])p, (int)0, (URI)AasUtils.EMPTY_URI))));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_GETID), p -> EcsFactory.getContainerManager().getId(AasUtils.readUri((Object[])p, (int)0, (URI)AasUtils.EMPTY_URI)));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CONTAINER_ADD_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> EcsFactory.getContainerManager().addContainer(AasUtils.readUri((Object[])p, (int)0, (URI)AasUtils.EMPTY_URI)), p -> AasUtils.readString((Object[])p, (int)1)));
        sBuilder.defineOperation(EcsAas.getQName(NAME_OP_CREATE_REMOTE_CONNECTION_CREDENTIALS), p -> {
            Credentials credentials = RemoteAccessServerFactory.create().getCredentialsManager().addGeneratedCredentials();
            String result = null;
            try {
                result = Json.writeValueAsStringDflt((Object)credentials);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(EcsAas.class).error("createRemoteConnectionCredentials: " + e.getMessage());
            }
            return result;
        });
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    private void createIdOp(SubmodelElementCollection.SubmodelElementCollectionBuilder smB, String name, InvocablesCreator iCreator, String ... otherParams) {
        Operation.OperationBuilder oBuilder = smB.createOperationBuilder(name).setInvocable(iCreator.createInvocable(EcsAas.getQName(name))).addInputVariable(NAME_PROP_ID, Type.STRING);
        for (String p : otherParams) {
            oBuilder.addInputVariable(p, Type.STRING);
        }
        ((Operation.OperationBuilder)oBuilder.addOutputVariable("result", Type.STRING).rbacAllAuthenticated(this.getSubmodelAuthentication())).build();
    }

    public static String getQName(String elementName) {
        return "resources_" + elementName;
    }

    private static void addContainer(Submodel.SubmodelBuilder smB, ContainerDescriptor desc) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder cBuilder = smB.createSubmodelElementCollectionBuilder(NAME_COLL_CONTAINERS);
        SubmodelElementCollection.SubmodelElementCollectionBuilder dBuilder = cBuilder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)desc.getId()));
        dBuilder.createPropertyBuilder(NAME_PROP_ID).setValue(Type.STRING, (Object)desc.getId()).build();
        dBuilder.createPropertyBuilder(NAME_PROP_NAME).setValue(Type.STRING, (Object)desc.getName()).setSemanticId("0173-1#02-AAO247#002").build();
        dBuilder.createPropertyBuilder(NAME_PROP_VERSION).setValue(Type.STRING, (Object)desc.getVersion().toString()).setSemanticId("0173-1#02-AAM737#002").build();
        dBuilder.createPropertyBuilder(NAME_PROP_STATE).setValue(Type.STRING, (Object)desc.getState().toString()).build();
        dBuilder.createPropertyBuilder(NAME_PROP_RESOURCE).setValue(Type.STRING, (Object)Id.getDeviceIdAas()).build();
        dBuilder.build();
        cBuilder.build();
        Transport.sendContainerStatus((ActionType)ActionTypes.ADDED, (String)desc.getId(), (String[])new String[0]);
    }

    public static void notifyContainerAdded(ContainerDescriptor desc) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            Submodel.SubmodelBuilder builder = AasPartRegistry.createSubmodelBuilder((Aas)aas, (String)NAME_SUBMODEL);
            EcsAas.addContainer(builder, desc);
            builder.build();
        });
    }

    public static void notifyContainerRemoved(ContainerDescriptor desc) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            SubmodelElementCollection coll = sub.getSubmodelElementCollection(NAME_COLL_CONTAINERS);
            coll.deleteElement(AasUtils.fixId((String)desc.getId()));
            Transport.sendContainerStatus((ActionType)ActionTypes.REMOVED, (String)desc.getId(), (String[])new String[0]);
        });
    }

    public static void notifyResourceRemoved() {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS, (sub, aas) -> {
            ContainerManager mgr = EcsFactory.getContainerManager();
            if (null != mgr) {
                SubmodelElementCollection coll = sub.getSubmodelElementCollection(NAME_COLL_CONTAINERS);
                for (ContainerDescriptor containerDescriptor : mgr.getContainers()) {
                    coll.deleteElement(AasUtils.fixId((String)containerDescriptor.getId()));
                }
                SubmodelElement elt = sub.getSubmodelElement(AasUtils.fixId((String)Id.getDeviceIdAas()));
                if (null != elt) {
                    sub.deleteElement(elt);
                }
            }
        });
    }

    public static void removeDevice(String deviceId, Consumer<Submodel> marker, Consumer<Submodel> piggyback) {
        String aasDeviceId = AasUtils.fixId((String)deviceId);
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS, (sub, aas) -> {
            SubmodelElement elt;
            if (null != marker) {
                marker.accept(sub);
            }
            SubmodelElementCollection coll = sub.getSubmodelElementCollection(NAME_COLL_CONTAINERS);
            Predicate pred = ActiveAasBase.createPropertyPredicate((String)NAME_PROP_RESOURCE, (Object)aasDeviceId, (String)("While deleting resource " + deviceId));
            ActiveAasBase.clearCollection((SubmodelElementCollection)coll, (Predicate)pred);
            if (null != piggyback) {
                piggyback.accept(sub);
            }
            if (null != (elt = sub.getSubmodelElement(aasDeviceId))) {
                sub.deleteElement(elt);
            }
        });
    }

    public static void notifyContainerStateChanged(ContainerDescriptor desc) {
        ActiveAasBase.processNotification((String)NAME_SUBMODEL, (sub, aas) -> {
            SubmodelElementCollection elt = sub.getSubmodelElementCollection(NAME_COLL_CONTAINERS).getSubmodelElementCollection(AasUtils.fixId((String)desc.getId()));
            if (null != elt) {
                Property prop = elt.getProperty(NAME_PROP_STATE);
                if (null != prop) {
                    try {
                        prop.setValue((Object)desc.getState().toString());
                    }
                    catch (ExecutionException e) {
                        EcsAas.getLogger().error("Cannot write state for container `" + desc.getId() + "`: " + e.getMessage());
                    }
                } else {
                    EcsAas.getLogger().error("Container state change - cannot find property statefor container `" + desc.getId());
                }
            } else {
                EcsAas.getLogger().error("Container state change - cannot find container `" + desc.getId() + "`");
            }
            Transport.sendContainerStatus((ActionType)ActionTypes.CHANGED, (String)desc.getId(), (String[])new String[0]);
        });
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EcsAas.class);
    }

    public static void enable() {
        enabled = true;
    }

    public boolean isValid() {
        return enabled;
    }
}

