/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.ssh;

import de.iip_ecosphere.platform.deviceMgt.Credentials;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.ssh.Ssh;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class RemoteAccessServer
implements Server {
    public static final String SSH_HOST = "0.0.0.0";
    public static final int SSH_PORT = 5555;
    private Ssh.SshServer server;
    private boolean started = false;
    private CredentialsManager credentialsManager = new CredentialsManager();

    RemoteAccessServer() {
    }

    public Server start() {
        if (this.server != null && !this.started) {
            try {
                this.server = Ssh.getInstance().createServer(new ServerAddress(Schema.SSH, SSH_HOST, 5555));
                this.server.setHostKey(new File("file.ser"));
                this.server.setAuthenticator((username, password) -> this.credentialsManager.authenticate(username, password));
                this.server = this.server.start();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(RemoteAccessServer.class).error("Starting Device Management SSH server: " + e.getMessage());
            }
        }
        return this;
    }

    public void stop(boolean dispose) {
        if (null != this.server) {
            this.server.stop(dispose);
        }
    }

    public boolean isStarted() {
        return null != this.server && this.server.isStarted();
    }

    public CredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    public class CredentialsManager {
        private List<Credentials> credentials = new ArrayList<Credentials>();

        public List<Credentials> getCredentials() {
            return this.credentials;
        }

        public Credentials getCredentials(String key) {
            return this.credentials.stream().filter(ts -> ts.getKey().equals(key)).findFirst().orElse(null);
        }

        public boolean authenticate(String key, String secret) {
            Credentials edgeTunnelSettings = this.getCredentials(key);
            return edgeTunnelSettings != null && edgeTunnelSettings.getSecret().equals(secret);
        }

        public void addCredentials(Credentials credentials) {
            this.credentials.add(credentials);
        }

        public Credentials addGeneratedCredentials() {
            Credentials credentials = new Credentials(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16), UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16));
            this.credentials.add(credentials);
            return credentials;
        }
    }
}

