/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.AbstractContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.BasicContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import test.de.iip_ecosphere.platform.ecsRuntime.MyContainerDesciptor;

class MyContainerManager
extends AbstractContainerManager<MyContainerDesciptor> {
    private static int id = 0;

    MyContainerManager() {
    }

    private String createId() {
        return "c-" + id++;
    }

    public String addContainer(URI location) throws ExecutionException {
        try {
            File file = this.resolveUri(location, null);
            LoggerFactory.getLogger(MyContainerManager.class).info("Adding container: URI {} resolved to ", (Object)location, (Object)file);
        }
        catch (IOException file) {
            // empty catch block
        }
        String sId = this.createId();
        return super.addContainer(sId, (ContainerDescriptor)new MyContainerDesciptor(sId, "cName", new Version(new int[]{0, 1}), new File("test.yml").toURI()));
    }

    public void startContainer(String id) throws ExecutionException {
        this.checkId(id, id);
        this.setState((BasicContainerDescriptor)this.getContainer(id, "id", "start"), ContainerState.DEPLOYED);
    }

    public void stopContainer(String id) throws ExecutionException {
        this.checkId(id, id);
        this.setState((BasicContainerDescriptor)this.getContainer(id, "id", "start"), ContainerState.STOPPED);
    }

    public void updateContainer(String id, URI location) throws ExecutionException {
        this.checkId(id, id);
    }

    public void undeployContainer(String id) throws ExecutionException {
        MyContainerDesciptor cnt = (MyContainerDesciptor)this.getContainer(id, "id", "undeploy");
        super.undeployContainer(id);
        this.setState(cnt, ContainerState.UNKNOWN);
    }

    public void migrateContainer(String containerId, String resourceId) throws ExecutionException {
        MyContainerDesciptor cnt = (MyContainerDesciptor)this.getContainer(containerId, "containerId", "migrate");
        String targetId = this.createId();
        MyContainerDesciptor tCnt = new MyContainerDesciptor(targetId, cnt.getName(), cnt.getVersion(), cnt.getUri());
        super.addContainer(targetId, (ContainerDescriptor)tCnt);
        super.migrateContainer(containerId, resourceId);
        this.setState(tCnt, ContainerState.DEPLOYED);
    }

    public String getContainerSystemName() {
        return "Fake Container System";
    }

    public String getContainerSystemVersion() {
        return "Fake Version";
    }
}

