/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.deviceAas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public abstract class AbstractDeviceProviderTest
extends TestWithPlugin {
    private static Server registryServer;
    private static Server aasServer;
    private static AasPartRegistry.AasSetup orig;

    @BeforeClass
    public static void startup() {
        AbstractDeviceProviderTest.loadPlugins();
        orig = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false));
        System.out.println("Registry: " + AasPartRegistry.getSetup().getRegistryEndpoint().toUri());
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Endpoint regEndpoint = AasPartRegistry.getSetup().getRegistryEndpoint();
        ServerRecipe.LocalPersistenceType pType = ServerRecipe.LocalPersistenceType.INMEMORY;
        LoggerFactory.getLogger(AbstractDeviceProviderTest.class).info("Starting " + String.valueOf(pType) + " AAS registry on " + regEndpoint.toUri());
        registryServer = rcp.createRegistryServer((SetupSpec)AasPartRegistry.getSetup(), (ServerRecipe.PersistenceType)pType, new String[0]);
        registryServer.start();
        Endpoint serverEndpoint = AasPartRegistry.getSetup().getServerEndpoint();
        LoggerFactory.getLogger(AbstractDeviceProviderTest.class).info("Starting " + String.valueOf(pType) + " AAS server on " + serverEndpoint.toUri());
        aasServer = rcp.createAasServer((SetupSpec)AasPartRegistry.getSetup(), (ServerRecipe.PersistenceType)pType, new String[0]);
        aasServer.start();
    }

    @AfterClass
    public static void shutdown() {
        registryServer.stop(true);
        aasServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)orig);
    }
}

