/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.ContainerDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.ContainerState;
import de.iip_ecosphere.platform.ecsRuntime.EcsAas;
import de.iip_ecosphere.platform.ecsRuntime.EcsAasClient;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.MeterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.LifecycleHandler;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AbstractAasLifecycleDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.transport.Transport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class EcsAasTest
extends TestWithQpid {
    private static Server qpid;
    private static final Predicate<Object> POSITIVE_GAUGE_VALUE;

    @BeforeClass
    public static void startup() {
        EcsAasTest.loadPlugins();
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        qpid = TestWithQpid.fromPlugin((ServerAddress)broker);
        EcsFactory.getSetup().getTransport().setPort(broker.getPort());
        qpid.start();
        Transport.setTransportSetup(() -> EcsFactory.getSetup().getTransport());
    }

    @AfterClass
    public static void shutdown() {
        qpid.stop(true);
        Transport.setTransportSetup(null);
    }

    @Test
    public void testAas() throws IOException, ExecutionException, URISyntaxException {
        Assert.assertNotNull((Object)EcsFactory.getSetupClass());
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(EcsAas.class));
        EcsAas.enable();
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false));
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Endpoint regEndpoint = AasPartRegistry.getSetup().getRegistryEndpoint();
        ServerRecipe.LocalPersistenceType pType = ServerRecipe.LocalPersistenceType.INMEMORY;
        System.out.println("Starting " + String.valueOf(pType) + " AAS registry on " + regEndpoint.toUri());
        Server registryServer = rcp.createRegistryServer((SetupSpec)AasPartRegistry.getSetup(), (ServerRecipe.PersistenceType)pType, new String[0]);
        registryServer.start();
        Endpoint serverEndpoint = AasPartRegistry.getSetup().getServerEndpoint();
        System.out.println("Starting " + String.valueOf(pType) + " AAS server on " + serverEndpoint.toUri());
        AasServer aasServer = rcp.createAasServer((SetupSpec)AasPartRegistry.getSetup(), (ServerRecipe.PersistenceType)pType, new String[0]);
        aasServer.start();
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(c -> c instanceof EcsAas);
        Server implServer = (Server)res.getProtocolServerBuilder().build();
        implServer.start();
        AasPartRegistry.remoteDeploy((List)res.getAas());
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        EcsAasClient client = new EcsAasClient(Id.getDeviceIdAas());
        this.test(client);
        HashMap<String, Predicate<Object>> expectedMetrics = new HashMap<String, Predicate<Object>>();
        expectedMetrics.put("Memory_Capacity", null);
        this.assertMetrics(expectedMetrics);
        aasServer.stop(true);
        implServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
        MetricsAasConstructor.clear();
    }

    @Test
    public void testLifecycle() throws IOException, ExecutionException, URISyntaxException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        boolean oldWaitIip = AbstractAasLifecycleDescriptor.setWaitForIipAas((boolean)false);
        AasPartRegistry.AasSetup aasSetup = AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false);
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)aasSetup);
        EcsFactory.getSetup().setAas(aasSetup);
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Server registryServer = rcp.createRegistryServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]).start();
        AasServer aasServer = rcp.createAasServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]).start();
        LifecycleHandler.startup((String[])new String[0]);
        TimeUtils.sleep((int)300);
        EcsAasClient client = new EcsAasClient(Id.getDeviceIdAas());
        long start = System.currentTimeMillis();
        this.test(client);
        long end = System.currentTimeMillis();
        long minDiff = (long)(10 * EcsFactory.getSetup().getMonitoringUpdatePeriod()) - (end - start);
        if (minDiff > 0L) {
            TimeUtils.sleep((int)((int)minDiff));
        }
        HashMap<String, Predicate<Object>> expectedMetrics = new HashMap<String, Predicate<Object>>();
        expectedMetrics.put("Memory_Capacity", POSITIVE_GAUGE_VALUE);
        expectedMetrics.put("Allocated_Memory", POSITIVE_GAUGE_VALUE);
        this.assertMetrics(expectedMetrics);
        LifecycleHandler.shutdown();
        aasServer.stop(true);
        registryServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        AbstractAasLifecycleDescriptor.setWaitForIipAas((boolean)oldWaitIip);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
        MetricsAasConstructor.clear();
    }

    private void assertMetrics(Map<String, Predicate<Object>> expected) throws IOException, ExecutionException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        Submodel resources = aas.getSubmodel("resources");
        Assert.assertNotNull((Object)resources);
        SubmodelElementCollection resource = resources.getSubmodelElementCollection(Id.getDeviceIdAas());
        Assert.assertNotNull((Object)resource);
        for (Map.Entry<String, Predicate<Object>> ent : expected.entrySet()) {
            Property prop = resource.getProperty(ent.getKey());
            Assert.assertNotNull((Object)prop);
            Predicate<Object> pred = ent.getValue();
            if (null == pred) continue;
            Object val = prop.getValue();
            Assert.assertTrue((String)(prop.getIdShort() + " " + String.valueOf(prop.getValue()) + " does not meet condition"), (boolean)pred.test(val));
        }
    }

    private void test(EcsAasClient client) throws ExecutionException, URISyntaxException, IOException {
        ContainerManager mgr = EcsFactory.getContainerManager();
        URI dummy = new URI("file:///dummy");
        String id = client.addContainer(dummy);
        Assert.assertNotNull((Object)id);
        Assert.assertTrue((id.length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)client.getContainers());
        int sleepMs = 300;
        ContainerDescriptor cnt = mgr.getContainer(id);
        Assert.assertEquals((Object)ContainerState.AVAILABLE, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.AVAILABLE, (Object)client.getState(id));
        Assert.assertTrue((boolean)mgr.getContainers().contains(cnt));
        Assert.assertTrue((boolean)mgr.getIds().contains(id));
        try {
            client.startContainer("");
            Assert.fail((String)"No exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        client.startContainer(id);
        TimeUtils.sleep((int)300);
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)client.getState(id));
        client.updateContainer(id, dummy);
        TimeUtils.sleep((int)300);
        client.stopContainer(id);
        TimeUtils.sleep((int)300);
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)client.getState(id));
        client.startContainer(id);
        TimeUtils.sleep((int)300);
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.DEPLOYED, (Object)client.getState(id));
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        try {
            client.undeployContainer(id);
            Assert.fail((String)"No exception");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        client.stopContainer(id);
        TimeUtils.sleep((int)300);
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.STOPPED, (Object)client.getState(id));
        client.undeployContainer(id);
        TimeUtils.sleep((int)300);
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)client.getState(id));
        id = client.addContainer(dummy);
        TimeUtils.sleep((int)300);
        cnt = mgr.getContainer(id);
        client.startContainer(id);
        TimeUtils.sleep((int)300);
        client.migrateContainer(id, "other");
        TimeUtils.sleep((int)300);
        if (ContainerState.STOPPED == cnt.getState()) {
            client.undeployContainer(id);
            TimeUtils.sleep((int)300);
        }
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)mgr.getState(id));
        Assert.assertEquals((Object)ContainerState.UNKNOWN, (Object)client.getState(id));
        Assert.assertFalse((boolean)mgr.getContainers().contains(cnt));
        Assert.assertTrue((mgr.getContainers().size() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)mgr.getIds().contains(id));
        Assert.assertTrue((mgr.getIds().size() > 0 ? 1 : 0) != 0);
    }

    static {
        POSITIVE_GAUGE_VALUE = o -> {
            if (o instanceof Number) {
                return ((Number)o).doubleValue() > 0.0;
            }
            if (o != null) {
                Meter meter = MeterRepresentation.parseMeter((String)o.toString(), (String[])new String[0]);
                Assert.assertTrue((boolean)(meter instanceof Gauge));
                return ((Gauge)meter).value() > 0.0;
            }
            Assert.fail((String)"predicate value is null");
            return false;
        };
    }
}

