/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.support.iip_aas.AasBasedSetup;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import de.iip_ecosphere.platform.support.setup.EnableSetupMerge;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@EnableSetupMerge
public class EcsSetup
extends AasBasedSetup {
    private TransportSetup transport = new TransportSetup();
    private NetworkManagerSetup netMgr = new NetworkManagerSetup();
    private int monitoringUpdatePeriod = 2000;
    private boolean autoOnOffboarding = true;
    private List<String> artifactInfixes = new ArrayList<String>();

    public int getMonitoringUpdatePeriod() {
        return this.monitoringUpdatePeriod;
    }

    public TransportSetup getTransport() {
        return this.transport;
    }

    public NetworkManagerSetup getNetMgr() {
        return this.netMgr;
    }

    public boolean getAutoOnOffboarding() {
        return this.autoOnOffboarding;
    }

    public List<String> getArtifactInfixes() {
        return this.artifactInfixes;
    }

    public void setMonitoringUpdatePeriod(int monitoringUpdatePeriod) {
        this.monitoringUpdatePeriod = Math.max(200, monitoringUpdatePeriod);
    }

    public void setTransport(TransportSetup transport) {
        this.transport = transport;
    }

    public void setNetMgr(NetworkManagerSetup netMgr) {
        this.netMgr = netMgr;
    }

    public void setAutoOnOffboarding(boolean implicitOnOffboarding) {
        this.autoOnOffboarding = implicitOnOffboarding;
    }

    public void setArtifactInfixes(List<String> artifactInfixes) {
        this.artifactInfixes = artifactInfixes;
    }

    public static <C extends EcsSetup> C readConfiguration(Class<C> cls) throws IOException {
        return (C)((Object)((EcsSetup)((Object)EcsSetup.readFromYaml(cls))));
    }

    public static EcsSetup readConfiguration() throws IOException {
        return (EcsSetup)((Object)EcsSetup.readFromYaml(EcsSetup.class));
    }

    public static abstract class AbstractManagerSetup {
        private String authenticationKey;

        public String getAuthenticationKey() {
            return this.authenticationKey;
        }

        public void setAuthenticationKey(String authenticationKey) {
            this.authenticationKey = authenticationKey;
        }
    }
}

