/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class Monitor {
    public static final String TRANSPORT_METRICS_CHANNEL = "EcsMetrics";
    private static MetricsProvider provider = new MetricsProvider(MetricsFactory.getInstance().createRegistry());
    private static Timer timer = new Timer();
    private static boolean update = false;

    static MetricsProvider getMetricsProvider() {
        return provider;
    }

    public static void startScheduling() {
        Transport.createConnector();
        Monitor.scheduleMonitoringTask();
    }

    private static void scheduleMonitoringTask() {
        final String id = Id.getDeviceId();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                provider.calculateMetrics();
                if (null != Transport.getConnector()) {
                    block5: {
                        try {
                            String json = provider.toJson(id, update, new MeterFilter[0]);
                            TransportConnector tc = Transport.getConnector();
                            if (null != tc) {
                                tc.asyncSend(Monitor.TRANSPORT_METRICS_CHANNEL, (Object)json);
                            } else {
                                LoggerFactory.getLogger(Monitor.class).error("Cannot sent monitoring message: No transport connector");
                            }
                            MetricsAasConstructor.pushToAasAlways((String)json, (String)"resources", (MetricsAasConstructor.CollectionSupplier)MetricsAasConstructor.DFLT_SUBMODEL_SUPPLIER, (boolean)update, null);
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(Monitor.class).error("Cannot sent monitoring message: " + e.getMessage());
                            if (!Thread.currentThread().isInterrupted()) break block5;
                            Monitor.scheduleMonitoringTask();
                        }
                    }
                    update = true;
                }
            }
        }, 0L, (long)EcsFactory.getSetup().getMonitoringUpdatePeriod());
    }

    public static void stopScheduling() {
        MetricsAasConstructor.clear();
        timer.cancel();
        Transport.releaseConnector();
    }
}

