/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import de.iip_ecosphere.platform.ecsRuntime.ContainerManager;
import de.iip_ecosphere.platform.ecsRuntime.EcsFactoryDescriptor;
import de.iip_ecosphere.platform.ecsRuntime.EcsSetup;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.Plugin;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import java.io.IOException;
import java.util.Optional;
import java.util.ServiceLoader;

public class EcsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EcsFactory.class.getName());
    private static EcsFactoryDescriptor desc;
    private static ContainerManager manager;
    private static EcsSetup conf;
    private static Class<? extends EcsSetup> confClass;

    private static void init() {
        if (null == desc) {
            Plugin plugin = PluginManager.getPlugin(EcsFactoryDescriptor.class);
            if (null != plugin) {
                desc = (EcsFactoryDescriptor)plugin.getInstance();
            } else {
                ServiceLoader loader = ServiceLoaderUtils.load(EcsFactoryDescriptor.class);
                Optional first = ServiceLoaderUtils.findFirst((ServiceLoader)loader);
                if (first.isPresent()) {
                    desc = (EcsFactoryDescriptor)first.get();
                } else {
                    LOGGER.info("No container manager available. No container operations offered in AAS.");
                }
            }
        }
        if (null == conf) {
            if (null != desc) {
                conf = desc.getSetup();
            } else {
                try {
                    conf = (EcsSetup)((Object)AbstractSetup.readFromYaml(EcsSetup.class));
                }
                catch (IOException e) {
                    conf = new EcsSetup();
                    LOGGER.error("No configuration, falling back to default " + e.getMessage());
                }
            }
        }
        if (null == confClass && null != desc) {
            confClass = desc.getSetupClass();
        }
    }

    public static ContainerManager getContainerManager() {
        if (null == manager) {
            EcsFactory.init();
            if (null != desc && null != (manager = desc.createContainerManagerInstance())) {
                LOGGER.info("Container manager implementation registered: " + manager.getClass().getName());
            }
        }
        return manager;
    }

    public static EcsSetup getSetup() {
        if (null == conf) {
            EcsFactory.init();
        }
        return conf;
    }

    public static Class<? extends EcsSetup> getSetupClass() {
        if (null == confClass) {
            EcsFactory.init();
        }
        return confClass;
    }

    static {
        manager = null;
    }
}

