/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public enum ContainerState {
    AVAILABLE,
    DEPLOYING,
    DEPLOYED,
    FAILED,
    MIGRATING,
    UPDATING,
    STOPPING,
    STOPPED,
    UNDEPLOYING,
    UNKNOWN;

    private static Map<ContainerState, Set<ContainerState>> validTransitions;

    private static void addValidTransition(ContainerState source, ContainerState ... targets) {
        Set<ContainerState> validTrans = validTransitions.get((Object)source);
        if (null == validTrans) {
            validTrans = new HashSet<ContainerState>();
            validTransitions.put(source, validTrans);
        }
        for (ContainerState t : targets) {
            validTrans.add(t);
        }
    }

    public boolean isValidTransition(ContainerState target) {
        boolean result = false;
        if (FAILED == target || UNKNOWN == target || this == target) {
            result = true;
        } else {
            Set<ContainerState> validTargets = validTransitions.get((Object)this);
            if (null != validTargets) {
                result = validTargets.contains((Object)target);
            }
        }
        return result;
    }

    public static void validateTransition(ContainerState source, ContainerState target) throws ExecutionException {
        if (null == source) {
            throw new ExecutionException("No source state given: null", null);
        }
        if (!source.isValidTransition(target)) {
            throw new ExecutionException("State transition from " + String.valueOf((Object)source) + " to " + String.valueOf((Object)target) + " is not valid", null);
        }
    }

    static {
        validTransitions = new HashMap<ContainerState, Set<ContainerState>>();
        ContainerState.addValidTransition(UNKNOWN, AVAILABLE);
        ContainerState.addValidTransition(AVAILABLE, DEPLOYING, DEPLOYED);
        ContainerState.addValidTransition(DEPLOYING, DEPLOYED);
        ContainerState.addValidTransition(DEPLOYED, MIGRATING, UPDATING, STOPPING, STOPPED);
        ContainerState.addValidTransition(MIGRATING, DEPLOYED, STOPPING);
        ContainerState.addValidTransition(UPDATING, DEPLOYED, STOPPING);
        ContainerState.addValidTransition(STOPPING, STOPPED);
        ContainerState.addValidTransition(STOPPED, DEPLOYED, UNDEPLOYING);
        ContainerState.addValidTransition(UNDEPLOYING, UNKNOWN);
        ContainerState.addValidTransition(FAILED, DEPLOYED, MIGRATING, UPDATING, STOPPING);
    }
}

