/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.ecsRuntime.deviceAas;

import de.iip_ecosphere.platform.ecsRuntime.EcsFactory;
import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProvider;
import de.iip_ecosphere.platform.ecsRuntime.deviceAas.DeviceAasProviderDescriptor;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.iip_aas.NameplateSetup;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.io.InputStream;

public class YamlDeviceAasProvider
extends DeviceAasProvider {
    public static final String SUBMODEL_NAMEPLATE = "Nameplate";
    public static final String NAME_PROPERTY_PRODUCTIMAGE = "ProductImage";
    private String aasAddress = null;

    @Override
    public String getURN() {
        return "urn:::AAS:::" + this.getIdShort() + "#";
    }

    @Override
    public String getIdShort() {
        return AasUtils.fixId((String)("device" + Id.getDeviceIdAas()));
    }

    @Override
    public String getDeviceAasAddress() {
        if (null == this.aasAddress) {
            String id = this.getIdShort();
            String urn = this.getURN();
            Aas aas = null;
            try {
                NameplateSetup nSetup = YamlDeviceAasProvider.obtainNameplateSetup();
                aas = nSetup.createAas(urn, id, ab -> {
                    Submodel.SubmodelBuilder smb = ab.createSubmodelBuilder("metrics", NameplateSetup.expandUrn((String)urn, (String)"-metrics"));
                    MetricsAasConstructor.addProviderMetricsToAasSubmodel((SubmodelElementContainerBuilder)smb, null, (String)"EcsMetrics", (String)Id.getDeviceId(), (TransportSetup)EcsFactory.getSetup().getTransport());
                    smb.build();
                });
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Device AAS cannot be created: : {}", (Object)e.getMessage());
            }
            if (null != aas) {
                try {
                    AasFactory factory = AasFactory.getInstance();
                    Registry reg = factory.obtainRegistry((SetupSpec)AasPartRegistry.getSetup());
                    this.aasAddress = reg.getEndpoint(aas);
                    LoggerFactory.getLogger(this.getClass()).info("Device AAS address for {}/{}: {}", new Object[]{id, urn, this.aasAddress});
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Obtaining factory/endpoint: {}", (Object)e.getMessage());
                }
            }
        }
        return this.aasAddress;
    }

    public static NameplateSetup obtainNameplateSetup() throws IOException {
        InputStream is = NameplateSetup.resolveNameplateSetup();
        if (null == is) {
            String fName = Id.getDeviceId().toUpperCase() + ".yml";
            LoggerFactory.getLogger(YamlDeviceAasProvider.class).info("Checking AAS for id {} in resource file {}", (Object)Id.getDeviceId(), (Object)fName);
            is = AasUtils.CLASSPATH_RESOURCE_RESOLVER.resolve(fName);
            if (null == is) {
                fName = Id.getDeviceId().toLowerCase() + ".yml";
                LoggerFactory.getLogger(YamlDeviceAasProvider.class).info("Checking AAS for id {} in resource file {}", (Object)Id.getDeviceId(), (Object)fName);
                is = AasUtils.CLASSPATH_RESOURCE_RESOLVER.resolve(fName);
            }
        }
        return (NameplateSetup)AbstractSetup.readFromYaml(NameplateSetup.class, (InputStream)is);
    }

    public static class Descriptor
    implements DeviceAasProviderDescriptor {
        @Override
        public DeviceAasProvider createInstance() {
            return new YamlDeviceAasProvider();
        }

        @Override
        public boolean createsMultiProvider() {
            return false;
        }
    }
}

