/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.examples;

import de.iip_ecosphere.platform.examples.SpringStartup;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.collector.Collector;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.easyProducer.AbstractIvmlTests;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class ConfigurationTests
extends TestWithQpid {
    private static ServerAddress broker;
    private static Server server;
    private static final Consumer<String> SIMPLE_RECEIVED_ASSERTER;
    private static final boolean DEBUG = false;

    private static final void configureProcess(ProcessBuilder pb, File res) {
        pb.redirectOutput(res);
    }

    private static final void assertContains(String output, String test) {
        Assert.assertTrue((String)("Output does not contain '" + test + "':\n" + output), (output.indexOf(test) > 0 ? 1 : 0) != 0);
    }

    private static final void assertMatches(String output, String regEx) {
        Pattern p = Pattern.compile(regEx, 40);
        Assert.assertTrue((String)("Output does not match '" + regEx + "':\n" + output), (boolean)p.matcher(output).matches());
    }

    @BeforeClass
    public static void startup() {
        TestWithQpid.loadPlugins();
        broker = new ServerAddress(Schema.IGNORE);
        server = TestWithQpid.fromPlugin((ServerAddress)broker);
        server.start();
    }

    @AfterClass
    public static void shutdown() {
        server.stop(true);
    }

    private void testInstantiatedExample(String folder, String appName, int stopTime, Consumer<String> asserter) throws IOException {
        String base = AbstractIvmlTests.stripTestingEasyModelParent((File)AbstractIvmlTests.TEST_BASE_FOLDER);
        long start = System.currentTimeMillis();
        File cfg = new File(System.getProperty("test.genFolder", "../../configuration/configuration.easy/" + base));
        if (!cfg.exists()) {
            cfg = new File("../../../../IIP_configuration.easy/platform/configuration/configuration.easy/" + base);
        }
        System.out.println("Using folder " + cfg.getAbsolutePath());
        Assert.assertTrue((String)"configuration.easy must be built before", (boolean)cfg.exists());
        File f = new File(cfg, folder + "/" + appName + "/target/" + appName + "-0.1.0-SNAPSHOT-bin.jar");
        File res = File.createTempFile("examples-test-" + appName, ".out");
        SpringStartup.start((File)f, (boolean)false, p -> ConfigurationTests.configureProcess(p, res), (String[])new String[]{"--iip.test.stop=" + stopTime, "--iip.test.brokerPort=" + broker.getPort()});
        asserter.accept(FileUtils.readFileToString((File)res));
        Collector.collect((String)("examples." + folder)).addExecutionTimeMs(System.currentTimeMillis() - start).close();
    }

    @Test
    public void testSimpleMesh() throws IOException {
        this.testInstantiatedExample("SimpleMesh", "SimpleMeshTestingApp", 25000, SIMPLE_RECEIVED_ASSERTER);
    }

    @Test
    public void testSimpleMesh3() throws IOException {
        this.testInstantiatedExample("SimpleMesh3", "SimpleMeshTestingApp3", 35000, SIMPLE_RECEIVED_ASSERTER);
    }

    @Test
    public void testRoutingTest() throws IOException {
        this.testInstantiatedExample("RoutingTest", "RoutingTestApp", 25000, s -> {
            ConfigurationTests.assertContains(s, "RECEIVED: RoutingTestDataImpl[");
            ConfigurationTests.assertMatches(s, ".*RECEIVED: RoutingTestDataImpl\\[.* - P1\\].*");
            ConfigurationTests.assertMatches(s, ".*RECEIVED: RoutingTestDataImpl\\[.* - P2\\].*");
            ConfigurationTests.assertMatches(s, ".*RECEIVED: RoutingTestDataImpl\\[.* - P3\\].*");
            ConfigurationTests.assertContains(s, "Processor received: RoutingConnOutImpl[");
            ConfigurationTests.assertContains(s, "Processor sent: RoutingTestDataImpl[");
            ConfigurationTests.assertContains(s, "Source received cmd: RoutingCommandImpl[cmd=Batch completed]");
            ConfigurationTests.assertContains(s, "Processor received cmd: RoutingCommandImpl[cmd=Batch completed]");
            ConfigurationTests.assertContains(s, "Connector received cmd: RoutingCommandImpl[cmd=Batch completed]");
            ConfigurationTests.assertContains(s, "Processor P1 received cmd: RoutingCommandImpl[cmd=Batch completed]");
            ConfigurationTests.assertContains(s, "Processor P2 received cmd: RoutingCommandImpl[cmd=Batch completed]");
            ConfigurationTests.assertContains(s, "Processor P3 received cmd: RoutingCommandImpl[cmd=Batch completed]");
        });
    }

    static {
        SIMPLE_RECEIVED_ASSERTER = s -> ConfigurationTests.assertContains(s, "RECEIVED ");
    }
}

