/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.examples;

import de.iip_ecosphere.platform.examples.PersistentLocalNetworkManagerImpl;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class PersistentLocalNetworkManagerDescriptor
implements NetworkManagerDescriptor {
    public static final long STORE_TIMEOUT = 60000L;

    public static File getFile() {
        return new File(FileUtils.getTempDirectory(), "iip-persNetwMgr.ser");
    }

    public NetworkManager createInstance() {
        PersistentLocalNetworkManagerImpl result = new PersistentLocalNetworkManagerImpl();
        File f = PersistentLocalNetworkManagerDescriptor.getFile();
        if (!f.exists()) {
            LoggerFactory.getLogger(this.getClass()).info("No persisted network manager information found. Initializing empty.");
        } else if (System.currentTimeMillis() - f.lastModified() > 60000L) {
            LoggerFactory.getLogger(this.getClass()).info("Persisted network manager information found, but outdated ({} ms). Initializing empty.", (Object)60000L);
        } else {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                result.readFrom(ois);
                ois.close();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> FileUtils.deleteQuietly((File)f)));
                LoggerFactory.getLogger(this.getClass()).info("Loaded persistent local network manager data");
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Cannot read persistent local network manager data: {}", (Object)e.getMessage());
            }
        }
        return result;
    }
}

