/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.invoker;

import de.iip_ecosphere.platform.tools.maven.invoker.SystemProperty;
import de.iip_ecosphere.platform.tools.maven.python.FileChangeDetector;
import de.iip_ecosphere.platform.tools.maven.python.FilesetUtils;
import de.iip_ecosphere.platform.tools.maven.python.Logger;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.model.fileset.FileSet;

public class AbstractInvokerMojo
extends AbstractMojo
implements Logger {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private List<String> invokeGoals;
    @Parameter
    private List<String> invokeProfiles;
    @Parameter
    private List<SystemProperty> systemProperties;
    @Parameter(defaultValue="${settings.localRepository}")
    private File localRepositoryPath;
    @Parameter(defaultValue="false")
    private boolean showVersion;
    @Parameter(defaultValue="true")
    private boolean showErrors;
    @Parameter
    private File javaHome;
    @Parameter
    private File mavenHome;
    @Parameter
    private File mavenExecutable;
    @Parameter(defaultValue="0")
    private int timeoutInSeconds;
    @Parameter
    private File pom;
    @Parameter(defaultValue="${session.offline}")
    private boolean offline;
    @Parameter(defaultValue="${session.request}")
    private MavenExecutionRequest execRequest;
    @Parameter(property="okto.mvn.home", required=false)
    private String oktoMvnHome;
    @Parameter(property="skipTests", required=false)
    private String skipTests;
    @Parameter(property="maven.test.skip", required=false, defaultValue="false")
    private boolean mavenTestSkip;
    @Parameter(property="unpack.force", required=false, defaultValue="false")
    private boolean unpackForce;
    @Parameter(property="configuration.force", required=false, defaultValue="false")
    private boolean configForce;
    @Parameter(property="disableJava", defaultValue="false")
    private boolean disableJava;
    @Parameter(property="disableJavaTests", defaultValue="false")
    private boolean disableJavaTests;
    @Parameter(property="disablePython", defaultValue="false")
    private boolean disablePython;
    @Parameter(property="disablePythonTests", defaultValue="false")
    private boolean disablePythonTests;
    @Parameter(property="disableBuild", defaultValue="false")
    private boolean disableBuild;
    @Parameter(property="python-compile.hashDir", defaultValue="")
    private String pythonCompileHashDir;
    @Parameter(property="maven.javadoc.skip", defaultValue="false")
    private boolean mavenJavadocSkip;
    @Parameter(property="maven.assembly.skip", defaultValue="false")
    private boolean mavenAssemblySkip;
    @Parameter(property="maven.source.skip", defaultValue="false")
    private boolean mavenSourceSkip;
    @Parameter(property="maven.build.cache.enabled")
    private String mavenBuildCacheEnabled;
    @Parameter(property="enableJavadoc", defaultValue="false")
    private boolean enableJavadoc;
    @Parameter(property="invoker.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="invoker.skipIfExists", defaultValue="")
    private File skipIfExists;
    @Parameter(property="invoker.executeIfExists", defaultValue="")
    private File executeIfExists;
    @Parameter(property="iip.ciBuildId", defaultValue="")
    private String buildId;
    @Parameter(property="okto.test.easy.model.parent", defaultValue="")
    private String oktoModelParent;
    @Parameter(property="easy.docker.failOnError")
    private String easyDockerFailOnError;
    @Parameter(property="easy.docker.skip")
    private String easyDockerSkip;
    @Parameter(property="configuration.tracingLevel")
    private String configTracingLevel;
    @Parameter(required=false)
    private FileSet changeTracking;
    @Parameter(required=false)
    private String changeTrackingHashFile;
    @Parameter(property="invoker.touchIfExecuted", required=false, defaultValue="")
    private File touchIfExecuted;
    @Component
    private Invoker invoker;
    private boolean enabled = true;

    public void disable() {
        this.enabled = false;
    }

    private InvocationRequest createBasicInvocationRequest() {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBatchMode(true);
        request.setLocalRepositoryDirectory(this.localRepositoryPath);
        request.setShowErrors(this.showErrors);
        request.setShowVersion(this.showVersion);
        request.setJavaHome(this.javaHome);
        request.setMavenHome(this.mavenHome);
        request.setGoals(this.invokeGoals);
        request.setProfiles(this.invokeProfiles);
        request.setOffline(this.offline);
        request.setDebug(this.debug);
        request.setMavenExecutable(this.mavenExecutable);
        request.setTimeoutInSeconds(this.timeoutInSeconds);
        return request;
    }

    private InvocationRequest createInvocationRequest() {
        InvocationRequest request = this.createBasicInvocationRequest();
        this.passThroughSysProperties(request);
        this.passThroughEnvSettings(request);
        File pomFile = this.pom;
        if (null == pomFile) {
            pomFile = this.project.getFile();
        }
        this.getLog().info((CharSequence)("Actual POM: " + String.valueOf(pomFile)));
        request.setBaseDirectory(pomFile.getParentFile());
        request.setPomFile(pomFile);
        return request;
    }

    private void passThroughSysProperties(InvocationRequest request) {
        String hashDir;
        Properties sysProperties = new Properties();
        if (null != this.systemProperties) {
            for (SystemProperty prop : this.systemProperties) {
                if (null != prop.getKey() && null != prop.getValue()) {
                    sysProperties.put(prop.getKey(), prop.getValue());
                    continue;
                }
                this.getLog().error((CharSequence)("Skipping property " + prop.getKey() + "=" + prop.getValue() + " as either key or value are not given"));
            }
        }
        boolean value = !this.enableJavadoc || this.mavenJavadocSkip;
        request.addShellEnvironment("MAVEN_ARGS", "-Dmaven.javadoc.skip=" + value);
        sysProperties.put("maven.javadoc.skip", String.valueOf(value));
        sysProperties.put("assembly.skipAssembly", String.valueOf(this.mavenAssemblySkip));
        sysProperties.put("maven.source.skip", String.valueOf(this.mavenSourceSkip));
        if (this.unpackForce && !sysProperties.containsKey("unpack.force")) {
            sysProperties.put("unpack.force", "true");
        }
        if (this.configForce && !sysProperties.containsKey("configuration.force")) {
            sysProperties.put("configuration.force", "true");
        }
        value = this.disableJava || this.disableBuild;
        sysProperties.put("maven.main.skip", String.valueOf(value));
        sysProperties.put("maven.javadoc.skip", String.valueOf(value));
        value = null == this.skipTests ? this.mavenTestSkip : Boolean.valueOf(this.skipTests);
        value = value || this.disableJava || this.disableBuild || this.disableJavaTests;
        sysProperties.put("maven.test.skip", String.valueOf(value));
        sysProperties.put("skipTests", String.valueOf(value));
        this.setAsProperty(sysProperties, "maven.build.cache.enabled", this.mavenBuildCacheEnabled);
        this.setAsProperty(sysProperties, "easy.docker.failOnError", this.easyDockerFailOnError);
        this.setAsProperty(sysProperties, "easy.docker.skip", this.easyDockerSkip);
        this.setAsProperty(sysProperties, "configuration.tracingLevel", this.configTracingLevel);
        value = this.disablePython || this.disableBuild;
        sysProperties.put("python-compile.skip", String.valueOf(value));
        sysProperties.put("python-test.skip", String.valueOf(value));
        value = this.disablePythonTests;
        sysProperties.put("python-test.skip", String.valueOf(value));
        if (this.buildId != null && this.buildId.length() > 0) {
            sysProperties.put("iip.ciBuildId", this.buildId);
        }
        if (this.oktoModelParent != null && this.oktoModelParent.length() > 0) {
            sysProperties.put("okto.test.easy.model.parent", this.oktoModelParent);
        }
        if (this.oktoMvnHome != null && this.oktoMvnHome.length() > 0) {
            sysProperties.put("okto.mvn.home", this.oktoMvnHome);
        }
        if (null == (hashDir = this.pythonCompileHashDir) || hashDir.length() == 0) {
            hashDir = this.project.getBuild().getDirectory();
        }
        sysProperties.put("python-compile.hashDir", hashDir);
        request.addShellEnvironment("PYTHON_COMPILE_HASHDIR", hashDir);
        request.setProperties(sysProperties);
        this.getLog().info((CharSequence)("Setting sys properties " + String.valueOf(request.getProperties())));
    }

    private void setAsProperty(Properties sysProperties, String key, String value) {
        if (value != null) {
            sysProperties.put(key, value);
        }
    }

    private void passThroughEnvSettings(InvocationRequest request) {
        String settings = System.getenv("MAVEN_SETTINGS_PATH");
        if (null == settings) {
            if (null != this.execRequest.getGlobalSettingsFile() && this.execRequest.getGlobalSettingsFile().exists()) {
                request.setGlobalSettingsFile(this.execRequest.getGlobalSettingsFile());
            }
            if (null != this.execRequest.getUserSettingsFile() && this.execRequest.getUserSettingsFile().exists()) {
                request.setUserSettingsFile(this.execRequest.getUserSettingsFile());
            }
            File tmp = this.execRequest.getUserSettingsFile();
            if (null == settings) {
                tmp = this.execRequest.getGlobalSettingsFile();
            }
            if (null != tmp && tmp.exists()) {
                settings = tmp.getAbsolutePath();
            }
        } else {
            request.setUserSettingsFile(new File(settings));
        }
        if (null != settings) {
            request.addShellEnvironment("MAVEN_SETTINGS_PATH", settings);
        }
        this.getLog().info((CharSequence)("Passing on env settings " + String.valueOf(request.getShellEnvironments())));
    }

    private FileSet getChangeTrackingFileSet() {
        FileSet result = this.changeTracking;
        if (null == result) {
            result = new FileSet();
            result.setDirectory(".");
            result.addInclude("src/**/*.java");
            result.addInclude("src/**/*.py");
            result.addInclude("pom.xml");
            result.addInclude("**/*.yml");
            result.addInclude("**/*.yaml");
            result.addInclude("**/*.json");
        }
        return result;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean enableOnChangeTracking;
        CapturingOutputHandler outputHandler = new CapturingOutputHandler(System.out);
        InvocationRequest request = this.createInvocationRequest();
        request.setOutputHandler((InvocationOutputHandler)outputHandler);
        boolean enableOnSkip = null == this.skipIfExists ? true : !this.skipIfExists.exists();
        boolean enableOnExecute = null == this.executeIfExists ? false : this.executeIfExists.exists();
        boolean enableOnFile = enableOnSkip || enableOnExecute;
        List trackedFiles = null;
        if (null != this.changeTrackingHashFile && this.changeTrackingHashFile.length() > 0) {
            File hashFile = FileChangeDetector.getHashFileInTarget((MavenProject)this.project, (String)this.changeTrackingHashFile);
            trackedFiles = FilesetUtils.listFiles((FileSet)this.getChangeTrackingFileSet(), (boolean)false);
            FileChangeDetector fcd = new FileChangeDetector(hashFile, (Logger)this, "invoker");
            fcd.readHashFile();
            trackedFiles = fcd.checkHashes(trackedFiles);
            fcd.writeHashFile();
        }
        boolean bl = enableOnChangeTracking = trackedFiles != null && trackedFiles.size() > 0;
        if (this.enabled && (enableOnFile || enableOnChangeTracking)) {
            try {
                this.getLog().info((CharSequence)(">>> Maven invoker: Using MAVEN_OPTS: " + request.getMavenOpts()));
                this.getLog().info((CharSequence)(">>> Executing: " + String.valueOf(new MavenCommandLineBuilder().build(request))));
            }
            catch (CommandLineConfigurationException ex) {
                this.getLog().debug((CharSequence)("Failed to display command line: " + ex.getMessage()));
            }
            try {
                InvocationResult result = this.invoker.execute(request);
                if (result.getExecutionException() != null) {
                    throw new MojoExecutionException("The Maven invocation failed. " + result.getExecutionException().getMessage());
                }
                if (result.getExitCode() != 0) {
                    throw new MojoExecutionException("The Maven invocation failed. Exit code: " + result.getExitCode());
                }
                if (outputHandler.indicatesBuildFailure()) {
                    throw new MojoExecutionException("The Maven invocation failed (indicated by log). " + result.getExecutionException().getMessage());
                }
            }
            catch (MavenInvocationException ex) {
                this.getLog().debug((CharSequence)("Error invoking Maven: " + ex.getMessage()), (Throwable)ex);
                throw new MojoExecutionException("Maven invocation failed. " + ex.getMessage());
            }
            FilesetUtils.touch((File)this.skipIfExists, (Log)this.getLog());
            FilesetUtils.touch((File)this.touchIfExecuted, (Log)this.getLog());
            FileUtils.deleteQuietly((File)this.executeIfExists);
            this.getLog().info((CharSequence)"<<< Maven invoker completed");
        } else {
            FileUtils.deleteQuietly((File)this.touchIfExecuted);
            if (this.enabled) {
                if (!enableOnSkip) {
                    this.getLog().info((CharSequence)("Maven invoker skipped as " + String.valueOf(this.skipIfExists) + " exists."));
                } else if (!enableOnChangeTracking && !enableOnExecute) {
                    this.getLog().info((CharSequence)"Maven invoker skipped as tracked files did not change.");
                }
            } else {
                this.getLog().info((CharSequence)"Maven invoker disabled, not executing.");
            }
        }
    }

    public void warn(String warning) {
        this.getLog().warn((CharSequence)warning);
    }

    public void error(String error) {
        this.getLog().error((CharSequence)error);
    }

    public void error(Throwable throwable) {
        this.getLog().error(throwable);
    }

    public void info(String info) {
        this.getLog().info((CharSequence)info);
    }

    private static class CapturingOutputHandler
    implements InvocationOutputHandler {
        private final PrintStream echoStream;
        private boolean indicatesBuildFailure;

        public CapturingOutputHandler(PrintStream echoStream) {
            this.echoStream = echoStream;
        }

        public void consumeLine(String line) {
            this.echoStream.println(line);
            line.contains("BUILD FAILURE");
        }

        public boolean indicatesBuildFailure() {
            return this.indicatesBuildFailure;
        }
    }
}

