/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.kiServices.functions.aggregation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class MultiChannelTimeSeriesAggregator<I, CI, O, D, T> {
    private boolean isAggregating;
    private T aggregationTimestamp;
    private int numberAggregatedSamples;
    private Map<String, CI> timePointAggregator = Collections.synchronizedMap(new HashMap());
    private Map<String, List<D>> timeSeriesAggregator = Collections.synchronizedMap(new HashMap());
    private AggregationFunction<I, CI, O, D, T> function;
    private Function<I, Iterator<CI>> iteratorProvider;

    public MultiChannelTimeSeriesAggregator(AggregationFunction<I, CI, O, D, T> function) {
        this(true, function);
    }

    public MultiChannelTimeSeriesAggregator(boolean isAggregating, AggregationFunction<I, CI, O, D, T> function, Function<I, Iterator<CI>> iteratorProvider) {
        if (null == function) {
            throw new IllegalArgumentException("function must be given");
        }
        if (null == iteratorProvider) {
            iteratorProvider = i -> null;
        }
        this.isAggregating = isAggregating;
        this.function = function;
        this.iteratorProvider = iteratorProvider;
    }

    public MultiChannelTimeSeriesAggregator(boolean isAggregating, AggregationFunction<I, CI, O, D, T> function) {
        this(isAggregating, function, null);
    }

    public boolean isAggregating() {
        return this.isAggregating;
    }

    public O process(I data) {
        O result = null;
        if (this.isAggregating) {
            Iterator<CI> iterator = this.iteratorProvider.apply(data);
            while (iterator.hasNext()) {
                O res = this.process(data, iterator.next());
                if (null != result) continue;
                result = res;
            }
        }
        return result;
    }

    protected O process(I parent, CI data) {
        String category;
        O result = null;
        if (null == this.aggregationTimestamp) {
            this.aggregationTimestamp = this.function.getTimestamp(parent);
        }
        if (!this.timePointAggregator.containsKey(category = this.function.getCategory(data))) {
            this.timePointAggregator.put(category, data);
        } else {
            Map<String, CI> tmp = this.timePointAggregator;
            this.timePointAggregator = Collections.synchronizedMap(new HashMap());
            for (Map.Entry<String, CI> e : tmp.entrySet()) {
                List<Object> ch = this.timeSeriesAggregator.get(e.getKey());
                if (null == ch) {
                    ch = Collections.synchronizedList(new LinkedList());
                    this.timeSeriesAggregator.put(e.getKey(), ch);
                }
                ch.add(this.function.getData(e.getValue()));
            }
            ++this.numberAggregatedSamples;
            if (this.function.chunkCompleted(this.numberAggregatedSamples, this.aggregationTimestamp)) {
                Map<String, List<D>> tmp2 = this.timeSeriesAggregator;
                this.timeSeriesAggregator = Collections.synchronizedMap(new HashMap());
                this.numberAggregatedSamples = 0;
                ResultBuilder<O, D, T> builder = this.function.createResult(tmp2.size());
                for (Map.Entry<String, List<D>> e : tmp2.entrySet()) {
                    builder.addData(e.getKey(), e.getValue(), this.aggregationTimestamp);
                }
                result = builder.build();
            }
        }
        return result;
    }

    public void startAggregating() {
        this.isAggregating = true;
    }

    public void stopAggregating() {
        this.isAggregating = false;
        this.timePointAggregator.clear();
        this.timeSeriesAggregator.clear();
    }

    public static interface AggregationFunction<I, CI, O, D, T>
    extends CompletionFunction<T> {
        public T getTimestamp(I var1);

        public String getCategory(CI var1);

        public D getData(CI var1);

        public ResultBuilder<O, D, T> createResult(int var1);
    }

    public static interface ResultBuilder<O, D, T> {
        public void addData(String var1, List<D> var2, T var3);

        public O build();
    }

    public static class ArrayIterator<I>
    implements Iterator<I> {
        private int pos = 0;
        private I[] array;

        public ArrayIterator(I[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.array.length > this.pos;
        }

        @Override
        public I next() {
            try {
                return this.array[this.pos++];
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }

    public static class SingleValueIterator<I>
    implements Iterator<I> {
        private I value;
        private boolean hasNext = true;

        public SingleValueIterator(I value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            boolean result = this.hasNext;
            this.hasNext = false;
            return result;
        }

        @Override
        public I next() {
            if (null == this.value) {
                throw new NoSuchElementException();
            }
            I v = this.value;
            this.value = null;
            return v;
        }
    }

    public static class LambdaBasedAggregationFunction<I, CI, O, D, T>
    implements AggregationFunction<I, CI, O, D, T> {
        private Function<I, T> timestampProvider;
        private Function<CI, String> categoryProvider;
        private Function<CI, D> dataProvider;
        private CompletionFunction<T> completionFunction;
        private Function<Integer, ResultBuilder<O, D, T>> resultBuilderProvider;

        public LambdaBasedAggregationFunction(Function<I, T> timestampProvider, Function<CI, String> categoryProvider, Function<CI, D> dataProvider, CompletionFunction<T> completionFunction, Function<Integer, ResultBuilder<O, D, T>> resultBuilderProvider) {
            this.timestampProvider = timestampProvider;
            this.categoryProvider = categoryProvider;
            this.dataProvider = dataProvider;
            this.resultBuilderProvider = resultBuilderProvider;
            this.completionFunction = completionFunction;
        }

        @Override
        public T getTimestamp(I input) {
            return this.timestampProvider.apply(input);
        }

        @Override
        public String getCategory(CI input) {
            return this.categoryProvider.apply(input);
        }

        @Override
        public D getData(CI input) {
            return this.dataProvider.apply(input);
        }

        @Override
        public boolean chunkCompleted(int numberAggregatedSamples, T timestamp) {
            return this.completionFunction.chunkCompleted(numberAggregatedSamples, timestamp);
        }

        @Override
        public ResultBuilder<O, D, T> createResult(int categoriesCount) {
            return this.resultBuilderProvider.apply(categoriesCount);
        }
    }

    public static interface CompletionFunction<T> {
        public boolean chunkCompleted(int var1, T var2);
    }
}

