/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.kiServices.functions.images;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import de.iip_ecosphere.platform.kiServices.functions.images.ImageEncodingDecoding;
import de.iip_ecosphere.platform.services.environment.ProcessSupport;
import de.iip_ecosphere.platform.support.FileUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;

public class QRCodeScanner {
    private static String resultScript = FileUtils.getTempDirectoryPath() + "/qr.res";
    private static ProcessSupport.ScriptOwner qrScriptOwner = new ProcessSupport.ScriptOwner("hm22-qr", "src/main/python/qrScan", "python-qr.zip", resultScript);

    public static String readQRCode(String b64image) throws IOException {
        BufferedImage image = null;
        image = ImageEncodingDecoding.base64StringToBufferdImage(b64image);
        String result = QRCodeScanner.readQRCode(image);
        return result;
    }

    public static String readQRCode(BufferedImage bufferedImage) {
        String encodedContent = null;
        try {
            BufferedImageLuminanceSource bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            HybridBinarizer hybridBinarizer = new HybridBinarizer((LuminanceSource)bufferedImageLuminanceSource);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)hybridBinarizer);
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            Result result = multiFormatReader.decode(binaryBitmap);
            encodedContent = result.getText();
        }
        catch (NotFoundException e) {
            System.out.println("NO QR CODE FOUND!!");
            encodedContent = "";
        }
        return encodedContent;
    }

    public static String pythonFallbackQRDetection(String b64Image) {
        System.out.println(qrScriptOwner.getResultFile());
        AtomicReference<String> resultRef = new AtomicReference<String>("");
        try {
            File f = File.createTempFile("hm22-qr", "b64");
            FileUtils.writeStringToFile((File)f, (String)b64Image, (Charset)StandardCharsets.UTF_8);
            ProcessSupport.callPython((ProcessSupport.ScriptOwner)qrScriptOwner, (String)"qr_scanner.py", qr -> {
                System.out.println("PYTHON QR " + qr);
                if (qr.isEmpty()) {
                    resultRef.set((String)qr);
                    System.out.println(">>> Python override QR scan: " + (String)resultRef.get());
                }
            }, (String[])new String[]{"-i", f.getAbsolutePath()});
            System.out.println(">>> Python process worked!");
            f.delete();
        }
        catch (IOException e) {
            System.out.println(">>> Python fallback error : " + e.getMessage());
        }
        return resultRef.get();
    }
}

