/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.python;

import de.iip_ecosphere.platform.tools.maven.python.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.project.MavenProject;

public class FileChangeDetector {
    public static final String FILE_EXTENSION = "fpf";
    private File md5File;
    private boolean useHash = true;
    private Logger logger;
    private String task;
    private transient Map<String, String> md5Hashes = new HashMap<String, String>();

    public FileChangeDetector(File md5File, Logger logger, String task) {
        this.md5File = md5File;
        this.logger = logger;
        this.task = task;
    }

    public FileChangeDetector useHash(boolean useHash) {
        this.useHash = useHash;
        return this;
    }

    public void readHashFile() {
        this.md5Hashes.clear();
        if (this.md5File.exists() && this.useHash) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.md5File));){
                this.md5Hashes = (Map)ois.readObject();
                this.logger.info("Using hash file " + this.md5File);
            }
            catch (IOException | ClassCastException | ClassNotFoundException e) {
                this.logger.warn("Cannot read existing fingerprint file '" + this.md5File.getName() + "': " + e.getMessage());
            }
        }
    }

    public void writeHashFile() {
        if (this.useHash) {
            this.md5File.getParentFile().mkdirs();
            try (ObjectOutputStream ois = new ObjectOutputStream(new FileOutputStream(this.md5File));){
                ois.writeObject(this.md5Hashes);
                this.logger.info("Wrote hash file " + this.md5File);
            }
            catch (IOException | ClassCastException e) {
                this.logger.warn("Write fingerprint file '" + this.md5File + "': " + e.getMessage());
            }
        }
    }

    public void remove(File file) {
        this.md5Hashes.remove(this.getHashFilePath(file));
    }

    private String getHashFilePath(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public List<File> checkHashes(List<File> files) {
        ArrayList<File> result = new ArrayList<File>();
        for (File f : files) {
            if (!f.exists()) continue;
            String path = this.getHashFilePath(f);
            String knownMd5 = this.md5Hashes.get(path);
            String md5 = null;
            try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                md5 = DigestUtils.md5Hex((InputStream)is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (md5 != null) {
                this.md5Hashes.put(path, md5);
            }
            if (knownMd5 != null) {
                if (!knownMd5.equals(md5)) {
                    result.add(f);
                    continue;
                }
                if (this.task == null || this.task.length() <= 0) continue;
                this.logger.info("Skipping " + this.task + " for " + f + " as unchanged.");
                continue;
            }
            result.add(f);
        }
        return result;
    }

    public static File getHashFileInTarget(MavenProject project, String hashFileName) {
        return new File(project.getBuild().getDirectory(), hashFileName + "." + FILE_EXTENSION);
    }
}

