/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.python;

import de.iip_ecosphere.platform.tools.maven.python.AbstractLoggingMojo;
import de.iip_ecosphere.platform.tools.maven.python.FileChangeDetector;
import de.iip_ecosphere.platform.tools.maven.python.PythonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="compile-python", defaultPhase=LifecyclePhase.COMPILE)
public class PythonCompileMojo
extends AbstractLoggingMojo {
    public static final String MD5_FILE = "python-compile.fpf";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="python-compile.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="python-compile.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="python-compile.useHash", required=false, defaultValue="true")
    private boolean useHash;
    @Parameter(property="python-compile.hashDir", required=false, defaultValue="")
    private String hashDir;
    @Parameter(property="python-compile.ignoreText", required=false, defaultValue="imported but unused;is assigned to but never used;redefinition of unused")
    private String ignoreText;
    @Parameter(property="python.binary", required=false, defaultValue="")
    private String python;
    @Parameter(property="python.pythonArgs", required=false, defaultValue="")
    private String pythonArgs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            String pythonExecutable = PythonUtils.getPythonExecutable(this.python).toString();
            this.getLog().info((CharSequence)("Using Python " + pythonExecutable));
            File baseDir = this.project.getBasedir();
            List<File> pythonFiles = PythonCompileMojo.getAllPythonFiles(new File(baseDir, "/src/main/python/").getAbsolutePath(), true);
            pythonFiles.addAll(PythonCompileMojo.getAllPythonFiles(new File(baseDir, "/src/test/python/").getAbsolutePath(), true));
            FileChangeDetector fcd = new FileChangeDetector(this.getHashFile(), this, "Python syntax check").useHash(this.useHash);
            fcd.readHashFile();
            String output = "";
            String errorLine = "";
            boolean pyflakesExists = true;
            for (File f : fcd.checkHashes(pythonFiles)) {
                String[] ignore;
                String[] cmd;
                this.getLog().info((CharSequence)("Testing Python syntax: " + f.getAbsolutePath()));
                if (pyflakesExists) {
                    cmd = new String[]{pythonExecutable, "-m", "pyflakes", f.getAbsolutePath()};
                    cmd = PythonUtils.insertArgs(cmd, 1, this.pythonArgs);
                    if ((output = output + PythonCompileMojo.runPythonTest(cmd)).contains("No module named")) {
                        boolean bl = pyflakesExists = !output.contains("pyflakes");
                    }
                }
                if (!pyflakesExists) {
                    cmd = new String[]{pythonExecutable, "-m", "py_compile", f.getAbsolutePath()};
                    cmd = PythonUtils.insertArgs(cmd, 1, this.pythonArgs);
                    output = output + PythonCompileMojo.runPythonTest(cmd);
                }
                String[] stringArray = ignore = null == this.ignoreText ? new String[]{} : this.ignoreText.split(";");
                if (output.length() <= 0) continue;
                boolean failure = false;
                String[] outputs = output.split("\n");
                String filteredOutput = "";
                for (String line : outputs) {
                    boolean addLine = true;
                    if (this.isError(line)) {
                        failure = true;
                        errorLine = line;
                    }
                    if (PythonCompileMojo.isContained(line, ignore)) {
                        addLine = false;
                    }
                    if (!addLine) continue;
                    if (filteredOutput.length() > 0) {
                        filteredOutput = filteredOutput + "\n";
                    }
                    filteredOutput = filteredOutput + line;
                }
                if (filteredOutput.length() > 0) {
                    this.getLog().info((CharSequence)filteredOutput);
                }
                if (!failure || !this.failOnError) continue;
                fcd.remove(f);
                fcd.writeHashFile();
                throw new MojoExecutionException(errorLine);
            }
            fcd.writeHashFile();
        } else {
            this.getLog().info((CharSequence)"Skipping Python compiler execution");
        }
    }

    private boolean isError(String line) {
        boolean isError = true;
        isError &= !line.contains("import");
        isError &= !line.contains("redefinition");
        isError &= !line.contains("but never used");
        isError &= !line.contains("is unused");
        return isError &= !line.contains("is never assigned in scope");
    }

    private static boolean isContained(String text, String[] substrings) {
        boolean contained = false;
        for (int i = 0; !contained && i < substrings.length; ++i) {
            contained = text.contains(substrings[i]);
        }
        return contained;
    }

    public static String runPythonTest(String[] cmd) {
        String output = "";
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            output = PythonCompileMojo.readProcessOutput(process.getInputStream());
            output = output + PythonCompileMojo.readProcessOutput(process.getErrorStream());
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return output;
    }

    static String readProcessOutput(InputStream stream) throws IOException {
        StringBuffer output = new StringBuffer();
        String line = "";
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            output.append(line);
            output.append("\n");
        }
        return output.toString();
    }

    static List<File> getAllPythonFiles(String directory, boolean recurse) {
        ArrayList<File> pythonFiles = new ArrayList<File>();
        File file = new File(directory);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (null != files) {
                    for (File f : files) {
                        if (f.isDirectory() && recurse) {
                            pythonFiles.addAll(PythonCompileMojo.getAllPythonFiles(f.getAbsolutePath(), true));
                            continue;
                        }
                        if (f.isDirectory() || !f.getAbsolutePath().endsWith(".py")) continue;
                        pythonFiles.add(f);
                    }
                }
            } else {
                pythonFiles.add(file);
            }
        }
        return pythonFiles;
    }

    public File getHashFile() {
        File result = null;
        String dir = this.hashDir;
        if (null == dir || dir.length() == 0) {
            dir = System.getenv("PYTHON_COMPILE_HASHDIR");
        }
        if (dir != null && dir.length() > 0) {
            result = new File(dir, this.project.getArtifactId() + "-" + MD5_FILE);
        }
        if (null == result) {
            result = new File(this.project.getBuild().getDirectory(), MD5_FILE);
        }
        return result;
    }
}

