/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.python;

import de.iip_ecosphere.platform.tools.maven.python.PythonCompileMojo;
import de.iip_ecosphere.platform.tools.maven.python.PythonUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

@Mojo(name="test-python", defaultPhase=LifecyclePhase.TEST)
public class PythonTestMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="python-test.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="python-test.modelProject", defaultValue="../../../target/pySrc")
    private String modelProject;
    @Parameter(property="skipTests", required=false, defaultValue="false")
    private boolean surefireSkip;
    @Parameter(property="maven.test.skip", required=false, defaultValue="false")
    private boolean mavenSkip;
    @Parameter(property="python-test.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="python-test.test", required=false, defaultValue="")
    private String test;
    @Parameter(property="python.binary", required=false, defaultValue="")
    private String python;
    @Parameter(property="python.pythonpath", required=false, defaultValue="")
    private String pythonPath;
    @Parameter(property="python.pythonArgs", required=false, defaultValue="")
    private String pythonArgs;
    @Parameter(required=false)
    private FileSet fileset;
    private int testedFileCount = 0;

    public void setTest(String test) {
        this.test = test;
    }

    public int getTestedFileCount(boolean reset) {
        int result = this.testedFileCount;
        if (reset) {
            this.testedFileCount = 0;
        }
        return result;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!(this.skip || this.surefireSkip || this.mavenSkip)) {
            File win;
            String testFile;
            List<Object> pythonFiles;
            File baseDir = this.project.getBasedir();
            if (null != this.fileset) {
                String[] includedFiles;
                pythonFiles = new ArrayList();
                FileSetManager fileSetManager = new FileSetManager();
                for (String string : includedFiles = fileSetManager.getIncludedFiles(this.fileset)) {
                    if (!string.endsWith(".py")) continue;
                    pythonFiles.add(new File(string));
                }
            } else {
                pythonFiles = PythonCompileMojo.getAllPythonFiles(new File(baseDir, "/src/test/python/").getAbsolutePath(), false);
            }
            String pythonExecutable = PythonUtils.getPythonExecutable(this.python).toString();
            this.getLog().info((CharSequence)("Using Python: " + pythonExecutable));
            String output = "";
            String string = testFile = this.test == null ? "" : this.test;
            if (testFile.length() > 0) {
                if (!testFile.endsWith(".py")) {
                    testFile = testFile + ".py";
                }
                this.getLog().info((CharSequence)("Seleted test file: " + testFile));
            }
            String[] envp = this.composeEnvironment();
            for (File file : pythonFiles) {
                if (testFile.length() != 0 && !file.getName().startsWith(testFile)) continue;
                this.getLog().info((CharSequence)("Executing Python test: " + file.getName()));
                String[] cmd = new String[]{pythonExecutable.toString(), file.getName(), this.modelProject};
                cmd = PythonUtils.insertArgs(cmd, 1, this.pythonArgs);
                output = output + this.runPythonTest(cmd, new File(baseDir, "src/test/python/").getAbsolutePath(), envp);
                ++this.testedFileCount;
            }
            if (output.length() > 0) {
                this.getLog().info((CharSequence)output);
            }
            if ((win = new File("src/test/python/%SystemDrive%")).exists() && win.isDirectory()) {
                FileUtils.deleteQuietly((File)win);
            }
            if (output.contains("Traceback")) {
                throw new MojoExecutionException(output, null);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping Python test execution");
        }
    }

    private String[] composeEnvironment() {
        CharSequence[] envp = null;
        if (null == this.pythonPath || this.pythonPath.length() == 0) {
            File[] sub;
            ArrayList<String> paths = new ArrayList<String>();
            PythonTestMojo.add(paths, "./target/pyEnv/iip");
            PythonTestMojo.add(paths, "./target/pyEnv");
            PythonTestMojo.add(paths, "./target/pySrc/iip");
            PythonTestMojo.add(paths, "./target/pySrc");
            File f = new File("target/gen");
            if (f.exists() && null != (sub = f.listFiles())) {
                for (File s : sub) {
                    File sai = new File(s, "ApplicationInterfaces");
                    if (!s.isDirectory() || !sai.isDirectory()) continue;
                    PythonTestMojo.add(paths, "./src/gen/" + s.getName() + "ApplicationInterfaces");
                }
            }
            if ((f = new File("src/main/python")).exists()) {
                sub = f.listFiles();
                if (null != sub) {
                    for (File s : sub) {
                        if (!s.isDirectory() || s.getName().equals("__pycache__")) continue;
                        PythonTestMojo.add(paths, "./src/main/python/" + s.getName());
                    }
                }
                PythonTestMojo.add(paths, "./src/main/python");
            }
            this.pythonPath = String.join((CharSequence)File.pathSeparator, paths);
        }
        envp = new String[]{"PYTHONPATH=" + this.pythonPath, "PRJ_HOME=" + new File("").getAbsolutePath()};
        this.getLog().info((CharSequence)("Using " + String.join((CharSequence)", ", envp)));
        return envp;
    }

    private String runPythonTest(String[] cmd, String workingDirectory, String[] envp) {
        String output = "";
        try {
            Process process = Runtime.getRuntime().exec(cmd, envp, new File(workingDirectory));
            output = PythonCompileMojo.readProcessOutput(process.getInputStream());
            output = output + PythonCompileMojo.readProcessOutput(process.getErrorStream());
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return output;
    }

    private static void add(List<String> paths, String path) {
        File f = new File(path);
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (f.exists()) {
            paths.add(f.getAbsolutePath());
        }
    }
}

