/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.metrics.micrometer;

import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.oktoflow.platform.support.metrics.micrometer.AbstractMeter;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerMeasurement;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerMeterFilter;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerMeterRegistry;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerTag;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilterReply;
import java.util.Iterator;
import java.util.function.Function;

public class MicrometerUtils {
    public static <T extends Enum<T>> T value(Class<T> cls, Enum<?> value, T dflt) {
        return MicrometerUtils.value(cls, value == null ? null : value.name(), dflt);
    }

    public static <T extends Enum<T>> T value(Class<T> cls, String value, T dflt) {
        T result;
        if (value == null) {
            result = dflt;
        } else {
            try {
                result = Enum.valueOf(cls, value);
            }
            catch (IllegalArgumentException e) {
                result = dflt;
            }
        }
        return result;
    }

    public static Meter.Id idValue(Meter.Id id) {
        return id instanceof AbstractMeter.MicrometerId ? ((AbstractMeter.MicrometerId)id).getId() : null;
    }

    public static Tag tagValue(de.iip_ecosphere.platform.support.metrics.Tag tag) {
        return tag instanceof MicrometerTag ? ((MicrometerTag)tag).getTag() : null;
    }

    public static io.micrometer.core.instrument.config.MeterFilter filterValue(MeterFilter filter) {
        return filter instanceof MicrometerMeterFilter ? ((MicrometerMeterFilter)filter).getFilter() : null;
    }

    public static MeterFilter mmFilterValue(io.micrometer.core.instrument.config.MeterFilter filter) {
        return new MicrometerMeterFilter(filter);
    }

    public static io.micrometer.core.instrument.config.MeterFilter[] filterValue(MeterFilter ... filter) {
        io.micrometer.core.instrument.config.MeterFilter[] result = new io.micrometer.core.instrument.config.MeterFilter[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            result[i] = MicrometerUtils.filterValue(filter[i]);
        }
        return result;
    }

    public static MeterFilter[] mmFilterValue(io.micrometer.core.instrument.config.MeterFilter ... filter) {
        MeterFilter[] result = new MeterFilter[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            result[i] = MicrometerUtils.mmFilterValue(filter[i]);
        }
        return result;
    }

    public static Meter.Type typeValue(Meter.Type value) {
        return MicrometerUtils.value(Meter.Type.class, value.name(), Meter.Type.OTHER);
    }

    public static Meter.Type mmTypeValue(Meter.Type value) {
        return MicrometerUtils.value(Meter.Type.class, value == null ? null : value.name(), Meter.Type.OTHER);
    }

    public static de.iip_ecosphere.platform.support.metrics.Statistic mmStatisticValue(Statistic value) {
        return MicrometerUtils.value(de.iip_ecosphere.platform.support.metrics.Statistic.class, value == null ? null : value.name(), de.iip_ecosphere.platform.support.metrics.Statistic.UNKNOWN);
    }

    public static Statistic statisticValue(de.iip_ecosphere.platform.support.metrics.Statistic statistic) {
        return MicrometerUtils.value(Statistic.class, statistic == null ? null : statistic.name(), Statistic.UNKNOWN);
    }

    public static <TS, TT> Iterable<TT> wrapIterable(final Iterable<TS> iter, final Function<TS, TT> func) {
        return new Iterable<TT>(){

            @Override
            public Iterator<TT> iterator() {
                return MicrometerUtils.wrapIterator(iter.iterator(), func);
            }
        };
    }

    public static <TS, TT> Iterator<TT> wrapIterator(final Iterator<TS> iter, final Function<TS, TT> func) {
        return new Iterator<TT>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public TT next() {
                return func.apply(iter.next());
            }
        };
    }

    public static Iterable<Measurement> mmWrapMeasurementIterable(Iterable<io.micrometer.core.instrument.Measurement> iter) {
        return MicrometerUtils.wrapIterable(iter, s -> new MicrometerMeasurement((io.micrometer.core.instrument.Measurement)s));
    }

    public static Iterable<Tag> wrapTagIterable(Iterable<de.iip_ecosphere.platform.support.metrics.Tag> iter) {
        return MicrometerUtils.wrapIterable(iter, s -> MicrometerUtils.tagValue(s));
    }

    public static Iterable<de.iip_ecosphere.platform.support.metrics.Tag> mmWrapTagIterable(Iterable<Tag> iter) {
        return MicrometerUtils.wrapIterable(iter, s -> new MicrometerTag((Tag)s));
    }

    public static Iterable<io.micrometer.core.instrument.Measurement> wrapMeasurementIterable(Iterable<Measurement> iter) {
        return MicrometerUtils.wrapIterable(iter, s -> ((MicrometerMeasurement)s).getMeasurement());
    }

    public static de.iip_ecosphere.platform.support.metrics.Meter createMeter(de.iip_ecosphere.platform.support.metrics.Meter meter, MeterCreator creator) {
        de.iip_ecosphere.platform.support.metrics.Meter result = null;
        if (meter instanceof AbstractMeter) {
            Meter.Id id = meter.getId();
            result = MicrometerMeterRegistry.wrap(creator.create(MicrometerUtils.idValue(id), MicrometerUtils.mmTypeValue(id.getType()), MicrometerUtils.wrapMeasurementIterable(meter.measure())), de.iip_ecosphere.platform.support.metrics.Meter.class);
        }
        return result;
    }

    public static io.micrometer.core.instrument.config.MeterFilter[] append(io.micrometer.core.instrument.config.MeterFilter[] base, io.micrometer.core.instrument.config.MeterFilter ... addition) {
        int i;
        io.micrometer.core.instrument.config.MeterFilter[] result = new io.micrometer.core.instrument.config.MeterFilter[base.length + addition.length];
        int pos = 0;
        for (i = 0; i < base.length; ++i) {
            result[pos++] = base[i];
        }
        for (i = 0; i < addition.length; ++i) {
            result[pos++] = addition[i];
        }
        return result;
    }

    public static void apply(MeterRegistry registry, io.micrometer.core.instrument.config.MeterFilter ... filters) {
        for (io.micrometer.core.instrument.config.MeterFilter f : filters) {
            registry.config().meterFilter(f);
        }
    }

    public static boolean include(Meter.Id id, io.micrometer.core.instrument.config.MeterFilter ... filters) {
        boolean include = true;
        for (int f = 0; include && f < filters.length; ++f) {
            MeterFilterReply reply = filters[f].accept(id);
            if (MeterFilterReply.DENY == reply) {
                include = false;
                continue;
            }
            if (MeterFilterReply.ACCEPT == reply) {
                include = true;
                break;
            }
            include = true;
        }
        return include;
    }

    public static boolean include(String id, io.micrometer.core.instrument.config.MeterFilter ... filters) {
        return MicrometerUtils.include(new Meter.Id(id, null, null, null, null), filters);
    }

    public static interface MeterCreator {
        public Meter create(Meter.Id var1, Meter.Type var2, Iterable<io.micrometer.core.instrument.Measurement> var3);
    }
}

