/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.data;

import io.prometheus.client.Counter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import si.matjazcerkvenik.alertmonitor.data.IDataManager;
import si.matjazcerkvenik.alertmonitor.data.InMemoryDataManager;
import si.matjazcerkvenik.alertmonitor.data.MongoDbDataManager;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.DTag;
import si.matjazcerkvenik.alertmonitor.model.TagColors;
import si.matjazcerkvenik.alertmonitor.model.Target;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PRule;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PTarget;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApi;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApiException;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.KafkaClient;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.util.MD5;
import si.matjazcerkvenik.alertmonitor.util.TaskManager;
import si.matjazcerkvenik.alertmonitor.web.WebhookMessage;
import si.matjazcerkvenik.simplelogger.SimpleLogger;

public class DAO {
    private SimpleLogger logger = LogFactory.getLogger();
    private static DAO instance;
    private IDataManager dataManager;
    private Map<String, DEvent> activeAlerts = new HashMap<String, DEvent>();
    private Map<String, DTag> tagMap = new HashMap<String, DTag>();
    private Map<String, String> warnings = new HashMap<String, String>();

    private DAO() {
        this.dataManager = AmProps.ALERTMONITOR_MONGODB_ENABLED ? new MongoDbDataManager() : new InMemoryDataManager();
        TaskManager.getInstance().startDbMaintenanceTimer();
    }

    public static DAO getInstance() {
        if (instance == null) {
            instance = new DAO();
        }
        return instance;
    }

    public IDataManager getDataManager() {
        return this.dataManager;
    }

    public void resetDataManager() {
        TaskManager.getInstance().stopDbMaintenanceTimer();
        this.dataManager.close();
        this.dataManager = AmProps.ALERTMONITOR_MONGODB_ENABLED ? new MongoDbDataManager() : new InMemoryDataManager();
        TaskManager.getInstance().startDbMaintenanceTimer();
    }

    public void addWebhookMessage(WebhookMessage message) {
        this.dataManager.addWebhookMessage(message);
        ++AmMetrics.webhookMessagesReceivedCount;
        ((Counter.Child)AmMetrics.alertmonitor_webhook_messages_received_total.labels(new String[]{message.getRemoteHost(), message.getMethod().toUpperCase()})).inc();
    }

    public List<WebhookMessage> getWebhookMessages() {
        return this.dataManager.getWebhookMessages();
    }

    public void addToJournal(List<DEvent> events) {
        this.dataManager.addToJournal(events);
        ++AmMetrics.journalReceivedCount;
        for (DEvent e : events) {
            ((Counter.Child)AmMetrics.alertmonitor_journal_messages_total.labels(new String[]{e.getSeverity()})).inc();
        }
    }

    public List<DEvent> getJournal() {
        return this.dataManager.getJournal();
    }

    public long getJournalSize() {
        return this.dataManager.getJournalSize();
    }

    public DEvent getEvent(String id) {
        DEvent event = this.dataManager.getEvent(id);
        if (event == null) {
            return null;
        }
        try {
            List<Object> ruleList = new ArrayList();
            PrometheusApi api = new PrometheusApi();
            ruleList = api.rules();
            for (PRule pRule : ruleList) {
                if (!event.getAlertname().equals(pRule.getName())) continue;
                event.setRuleExpression(pRule.getQuery());
                event.setRuleTimeLimit(pRule.getDuration());
            }
        }
        catch (PrometheusApiException e) {
            LogFactory.getLogger().error("DAO: failed to load rules; root cause: " + e.getMessage());
        }
        return event;
    }

    public boolean synchronizeAlerts(List<DEvent> alertList, boolean psync) {
        if (psync) {
            for (DEvent e : this.activeAlerts.values()) {
                e.setToBeDeleted(true);
            }
            ArrayList<DEvent> newAlerts = new ArrayList<DEvent>();
            int newAlertsCount = 0;
            for (DEvent e : alertList) {
                if (this.activeAlerts.containsKey(e.getCorrelationId())) {
                    this.logger.info("PSYNC: Alert exists: {uid=" + e.getUid() + ", cid=" + e.getCorrelationId() + ", alertname=" + e.getAlertname() + ", instance=" + e.getInstance() + "}");
                    this.activeAlerts.get(e.getCorrelationId()).setToBeDeleted(false);
                    continue;
                }
                this.logger.info("PSYNC: New alert: {uid=" + e.getUid() + ", cid=" + e.getCorrelationId() + ", alertname=" + e.getAlertname() + ", instance=" + e.getInstance() + "}");
                e.setFirstTimestamp(e.getTimestamp());
                e.setLastTimestamp(e.getTimestamp());
                this.addActiveAlert(e);
                newAlerts.add(e);
                ++newAlertsCount;
            }
            ArrayList<String> cidToDelete = new ArrayList<String>();
            for (DEvent e : this.activeAlerts.values()) {
                if (!e.isToBeDeleted()) continue;
                cidToDelete.add(e.getCorrelationId());
            }
            for (String cid : cidToDelete) {
                this.logger.info("PSYNC: Removing active alert: {cid=" + cid + "}");
                this.removeActiveAlert(this.activeAlerts.get(cid));
            }
            this.addToJournal(newAlerts);
            this.logger.info("PSYNC: total psync alerts count: " + alertList.size());
            this.logger.info("PSYNC: new alerts count: " + newAlertsCount);
            this.logger.info("PSYNC: alerts to be deleted: " + cidToDelete.size());
            return true;
        }
        for (DEvent e : alertList) {
            if (AmProps.ALERTMONITOR_KAFKA_ENABLED) {
                KafkaClient.getInstance().publish(AmProps.ALERTMONITOR_KAFKA_TOPIC, Formatter.toJson(e));
            }
            if (this.activeAlerts.containsKey(e.getCorrelationId())) {
                if (e.getSeverity().equalsIgnoreCase("clear")) {
                    this.removeActiveAlert(this.activeAlerts.get(e.getCorrelationId()));
                    this.logger.info("AlertmanagerProcessor: clear alert: uid: " + e.getUid() + ", cid=" + e.getCorrelationId() + ", alertName: " + e.getAlertname());
                    continue;
                }
                this.updateActiveAlert(e);
                this.logger.info("AlertmanagerProcessor: updating alert: uid: " + e.getUid() + ", counter=" + e.getCounter() + ", cid=" + e.getCorrelationId() + ", alertName: " + e.getAlertname());
                continue;
            }
            if (e.getSeverity().equalsIgnoreCase("clear")) continue;
            e.setFirstTimestamp(e.getTimestamp());
            e.setLastTimestamp(e.getTimestamp());
            this.addActiveAlert(e);
            this.logger.info("AlertmanagerProcessor: new alert: uid: " + e.getUid() + ", cid=" + e.getCorrelationId() + ", alertName: " + e.getAlertname());
        }
        DAO.getInstance().addToJournal(alertList);
        return true;
    }

    public Map<String, DEvent> getActiveAlerts() {
        return this.activeAlerts;
    }

    public void addActiveAlert(DEvent event) {
        this.activeAlerts.put(event.getCorrelationId(), event);
        ++AmMetrics.raisingEventCount;
        LogFactory.getAlertLog().write(event.toString());
        String[] array = event.getTags().split(",");
        for (int i = 0; i < array.length; ++i) {
            String tagName = array[i].trim();
            if (tagName.length() <= 0) continue;
            DTag t = new DTag(tagName, TagColors.getColor(tagName));
            this.tagMap.putIfAbsent(t.getName(), t);
        }
    }

    public void updateActiveAlert(DEvent newEvent) {
        DEvent existingEvent = this.activeAlerts.get(newEvent.getCorrelationId());
        newEvent.setFirstTimestamp(existingEvent.getFirstTimestamp());
        newEvent.setLastTimestamp(newEvent.getTimestamp());
        newEvent.setCounter(existingEvent.getCounter() + 1);
        this.activeAlerts.put(newEvent.getCorrelationId(), newEvent);
    }

    public void removeActiveAlert(DEvent activeAlert) {
        LogFactory.getLogger().info("original: " + activeAlert.toString());
        DEvent clearEvent = activeAlert.generateClearEvent();
        clearEvent.setClearUid(clearEvent.getUid());
        LogFactory.getLogger().info("clone:::: " + clearEvent.toString());
        activeAlert.setFirstTimestamp(activeAlert.getTimestamp());
        activeAlert.setLastTimestamp(clearEvent.getTimestamp());
        this.dataManager.handleAlarmClearing(clearEvent);
        this.activeAlerts.remove(activeAlert.getCorrelationId());
        this.removeObsoleteTags();
        ArrayList<DEvent> list = new ArrayList<DEvent>();
        list.add(clearEvent);
        this.addToJournal(list);
        ++AmMetrics.clearingEventCount;
        LogFactory.getAlertLog().write(activeAlert.toString());
    }

    private void removeObsoleteTags() {
        HashMap allTags = new HashMap();
        for (DEvent n : this.activeAlerts.values()) {
            String[] array = n.getTags().split(",");
            for (int i = 0; i < array.length; ++i) {
                String tagName = array[i].trim();
                if (tagName.length() <= 1) continue;
                allTags.putIfAbsent(tagName, null);
            }
        }
        if (allTags.isEmpty()) {
            this.tagMap.clear();
            return;
        }
        this.tagMap.entrySet().removeIf(entry -> !allTags.containsKey(entry.getKey()));
    }

    public List<DTag> getTags() {
        return new ArrayList<DTag>(this.tagMap.values());
    }

    public List<DEvent> getActiveAlarmsList(String severity) {
        List<DEvent> list = this.activeAlerts.values().stream().filter(notif -> notif.getSeverity().equals(severity)).collect(Collectors.toList());
        return list;
    }

    public List<Target> getTargets() {
        try {
            PrometheusApi api = new PrometheusApi();
            List<PTarget> pTargets = api.targets();
            HashMap<String, Target> targetsMap = new HashMap<String, Target>();
            for (PTarget pTarget : pTargets) {
                String host = pTarget.getLabels().get("instance");
                Target t = targetsMap.getOrDefault(host, new Target());
                t.setSmartTarget(false);
                t.setHealth(pTarget.getHealth());
                t.setHostname(host);
                t.setJob(pTarget.getLabels().get("job"));
                t.setId(MD5.getChecksum("host" + t.getHostname() + t.getJob()));
                for (DEvent n : this.getActiveAlerts().values()) {
                    if (!n.getInstance().equals(host)) continue;
                    t.addAlert(n);
                }
                targetsMap.put(t.getId(), t);
            }
            return new ArrayList<Target>(targetsMap.values());
        }
        catch (Exception e) {
            LogFactory.getLogger().error("DAO: failed getting targets; root cause: " + e.getMessage());
            return null;
        }
    }

    public List<Target> getSmartTargets() {
        try {
            PrometheusApi api = new PrometheusApi();
            List<PTarget> pTargets = api.targets();
            HashMap<String, Target> targetsMap = new HashMap<String, Target>();
            for (PTarget pTarget : pTargets) {
                String host = Formatter.stripInstance(pTarget.getLabels().get("instance"));
                Target t = targetsMap.getOrDefault(host, new Target());
                t.setSmartTarget(true);
                boolean up = false;
                if (pTarget.getHealth().equalsIgnoreCase("up")) {
                    up = true;
                }
                t.setUp(up || t.isUp());
                t.setHostname(host);
                t.setId(MD5.getChecksum("smarthost" + t.getHostname()));
                for (DEvent n : this.getActiveAlerts().values()) {
                    if (!n.getHostname().equals(host)) continue;
                    t.addAlert(n);
                }
                targetsMap.put(host, t);
            }
            return new ArrayList<Target>(targetsMap.values());
        }
        catch (PrometheusApiException e) {
            LogFactory.getLogger().error("DAO: failed getting targets; root cause: " + e.getMessage());
            return null;
        }
    }

    public Target getSingleTarget(String id) {
        List<Target> t1 = this.getTargets();
        for (Target t : t1) {
            if (!t.getId().equals(id)) continue;
            return t;
        }
        List<Target> t2 = this.getSmartTargets();
        for (Target t : t2) {
            if (!t.getId().equals(id)) continue;
            return t;
        }
        return null;
    }

    private List<Target> getTargetsFromProm() {
        try {
            PrometheusApi api = new PrometheusApi();
            List<PTarget> targets = api.targets();
            for (PTarget pTarget : targets) {
                Target t = new Target();
                t.setHostname(Formatter.stripInstance(pTarget.getDiscoveredLabels().get("__address__")));
                t.setId(MD5.getChecksum("host" + t.getHostname()));
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().error("Exception getting targets", (Throwable)e);
        }
        return new ArrayList<Target>();
    }

    public double calculateAlertsBalanceFactor() {
        if (this.activeAlerts.size() == 0) {
            return 0.0;
        }
        double d = (double)(5 * this.getActiveAlarmsList("critical").size() + 4 * this.getActiveAlarmsList("major").size() + 3 * this.getActiveAlarmsList("minor").size() + 2 * this.getActiveAlarmsList("warning").size()) * 1.0 / (double)this.activeAlerts.size();
        return d;
    }

    public void addWarning(String msgId, String msg) {
        this.warnings.put(msgId, msg);
    }

    public void removeWarning(String msgId) {
        this.warnings.remove(msgId);
    }

    public List<String> getWarnings() {
        return new ArrayList<String>(this.warnings.values());
    }
}

