/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.model;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.alertmanager.AlertmanagerProcessor;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PAlert;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApi;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.simplelogger.SimpleLogger;

public class PrometheusSyncTask
extends TimerTask {
    private SimpleLogger logger = LogFactory.getLogger();

    public static void main(String ... args) {
        AmProps.ALERTMONITOR_PROMETHEUS_SERVER = "http://pgcentos:9090";
        PrometheusSyncTask rt = new PrometheusSyncTask();
        rt.run();
    }

    @Override
    public void run() {
        this.logger.info("PSYNC: === starting periodic synchronization ===");
        AmMetrics.lastPsyncTimestamp = System.currentTimeMillis();
        try {
            PrometheusApi api = new PrometheusApi();
            List<PAlert> activeAlerts = api.alerts();
            if (activeAlerts == null) {
                this.logger.error("PSYNC: null response returned");
                this.logger.info("PSYNC: === Periodic synchronization complete ===");
                ++AmMetrics.psyncFailedCount;
                DAO.getInstance().addWarning("psync", "Synchronization is failing");
                return;
            }
            ArrayList<DEvent> pSyncAlerts = new ArrayList<DEvent>();
            for (PAlert alert : activeAlerts) {
                this.logger.debug(alert.toString());
                DEvent e = new DEvent();
                e.setTimestamp(System.currentTimeMillis());
                e.setAlertname(alert.getLabels().getOrDefault("alertname", "-unknown-"));
                e.setSource("PSYNC");
                e.setUserAgent("");
                e.setInstance(alert.getLabels().getOrDefault("instance", "-"));
                e.setHostname(Formatter.stripInstance(e.getInstance()));
                e.setNodename(alert.getLabels().getOrDefault("nodename", e.getInstance()));
                e.setInfo(alert.getLabels().getOrDefault("info", "-"));
                e.setJob(alert.getLabels().getOrDefault("job", "-"));
                e.setTags(alert.getLabels().getOrDefault("tags", ""));
                e.setSeverity(alert.getLabels().getOrDefault("severity", "indeterminate"));
                e.setPriority(alert.getLabels().getOrDefault("priority", "low"));
                e.setGroup(alert.getLabels().getOrDefault("group", "unknown"));
                e.setEventType(alert.getLabels().getOrDefault("eventType", "5"));
                e.setProbableCause(alert.getLabels().getOrDefault("probableCause", "1024"));
                e.setCurrentValue(alert.getAnnotations().getOrDefault("currentValue", "-"));
                e.setUrl(alert.getLabels().getOrDefault("url", ""));
                if (alert.getLabels().containsKey("description")) {
                    e.setDescription(alert.getLabels().getOrDefault("description", "-"));
                } else {
                    e.setDescription(alert.getAnnotations().getOrDefault("description", "-"));
                }
                String[] lblArray = AmProps.ALERTMONITOR_PROMETHEUS_ID_LABELS.split(",");
                String s = "{";
                for (int i = 0; i < lblArray.length; ++i) {
                    s = s + lblArray[i].trim() + "=\"" + alert.getLabels().getOrDefault(lblArray[i].trim(), "-") + "\", ";
                }
                s = s.substring(0, s.length() - 2) + "}";
                e.setPrometheusId(s);
                e.setOtherLabels(alert.getLabels());
                if (!alert.getState().equals("firing")) continue;
                e.setStatus("firing");
                if (!e.getSeverity().equals("clear")) {
                    e.setTags(e.getTags() + "," + e.getSeverity());
                }
                e.setTags(e.getTags() + "," + e.getPriority());
                e.setNodename(AlertmanagerProcessor.substitute(e.getNodename()));
                e.setInfo(AlertmanagerProcessor.substitute(e.getInfo()));
                e.setDescription(AlertmanagerProcessor.substitute(e.getDescription()));
                e.setTags(AlertmanagerProcessor.substitute(e.getTags()));
                e.setUrl(AlertmanagerProcessor.substitute(e.getUrl()));
                e.generateUID();
                e.generateCID();
                this.logger.debug("PSYNC: " + e.toString());
                pSyncAlerts.add(e);
            }
            DAO.getInstance().synchronizeAlerts(pSyncAlerts, true);
            ++AmMetrics.psyncSuccessCount;
            AmMetrics.alertmonitor_psync_success.set(1.0);
            DAO.getInstance().removeWarning("psync");
        }
        catch (Exception e) {
            this.logger.error("PSYNC: failed to synchronize alarms; root cause: " + e.getMessage());
            ++AmMetrics.psyncFailedCount;
            AmMetrics.alertmonitor_psync_success.set(0.0);
            DAO.getInstance().addWarning("psync", "Synchronization is failing");
        }
        this.logger.info("PSYNC: === Periodic synchronization complete ===");
    }
}

