/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.model.prometheus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.prometheus.client.Histogram;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.SSLException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PAlert;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PAlertsMessage;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PQueryMessage;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PRule;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PRuleGroup;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PRuleMessage;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PTarget;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PTargetMessage;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApiException;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.HttpClientFactory;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.simplelogger.SimpleLogger;

public class PrometheusApi {
    private SimpleLogger logger = LogFactory.getLogger();
    private String HTTP_CLIENT_USER_AGENT = "Alertmonitor/v1";
    private static long requestCount;

    public PQueryMessage query(String query) throws PrometheusApiException {
        this.logger.info("PrometheusApi: query: " + query);
        FormBody formBody = new FormBody.Builder().add("query", query).build();
        Request request = new Request.Builder().url(AmProps.ALERTMONITOR_PROMETHEUS_SERVER + "/api/v1/query").addHeader("User-Agent", this.HTTP_CLIENT_USER_AGENT).addHeader("Content-Type", "application/x-www-form-urlencoded").post((RequestBody)formBody).build();
        return this.doQueryRequest(request);
    }

    public PQueryMessage queryRange(String query, long start, long end, String step) throws PrometheusApiException {
        this.logger.info("PrometheusApi: queryRange: " + query);
        FormBody formBody = new FormBody.Builder().add("query", query).add("start", String.valueOf(start)).add("end", String.valueOf(end)).add("step", step).build();
        Request request = new Request.Builder().url(AmProps.ALERTMONITOR_PROMETHEUS_SERVER + "/api/v1/query_range").addHeader("User-Agent", this.HTTP_CLIENT_USER_AGENT).addHeader("Content-Type", "application/x-www-form-urlencoded").post((RequestBody)formBody).build();
        return this.doQueryRequest(request);
    }

    private PQueryMessage doQueryRequest(Request request) throws PrometheusApiException {
        String responseBody = this.execute(request);
        if (responseBody != null && responseBody.trim().length() > 0) {
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            PQueryMessage msg = (PQueryMessage)gson.fromJson(responseBody, PQueryMessage.class);
            this.logger.info("status: " + msg.getStatus());
            return msg;
        }
        return null;
    }

    public List<PAlert> alerts() throws PrometheusApiException {
        Request request = new Request.Builder().url(AmProps.ALERTMONITOR_PROMETHEUS_SERVER + "/api/v1/alerts").addHeader("User-Agent", this.HTTP_CLIENT_USER_AGENT).get().build();
        String responseBody = this.execute(request);
        if (responseBody != null && responseBody.trim().length() > 0) {
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            PAlertsMessage amMsg = (PAlertsMessage)gson.fromJson(responseBody, PAlertsMessage.class);
            return amMsg.getData().getAlerts();
        }
        return null;
    }

    public List<PTarget> targets() throws PrometheusApiException {
        Request request = new Request.Builder().url(AmProps.ALERTMONITOR_PROMETHEUS_SERVER + "/api/v1/targets").addHeader("User-Agent", this.HTTP_CLIENT_USER_AGENT).get().build();
        String responseBody = this.execute(request);
        if (responseBody != null && responseBody.trim().length() > 0) {
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            PTargetMessage targetMessage = (PTargetMessage)gson.fromJson(responseBody, PTargetMessage.class);
            return targetMessage.getData().getActiveTargets();
        }
        return null;
    }

    public void reload() throws PrometheusApiException {
        Request request = new Request.Builder().url(AmProps.ALERTMONITOR_PROMETHEUS_SERVER + "/-/reload").addHeader("User-Agent", this.HTTP_CLIENT_USER_AGENT).post(RequestBody.create((byte[])"".getBytes())).build();
        this.execute(request);
    }

    public List<PRule> rules() throws PrometheusApiException {
        Request request = new Request.Builder().url(AmProps.ALERTMONITOR_PROMETHEUS_SERVER + "/api/v1/rules").addHeader("User-Agent", this.HTTP_CLIENT_USER_AGENT).get().build();
        String responseBody = this.execute(request);
        if (responseBody != null && responseBody.trim().length() > 0) {
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            PRuleMessage rulesMessage = (PRuleMessage)gson.fromJson(responseBody, PRuleMessage.class);
            HashMap<String, PRule> rulesMap = new HashMap<String, PRule>();
            for (PRuleGroup g : rulesMessage.getData().getGroups()) {
                for (PRule rule : g.getRules()) {
                    if (rulesMap.containsKey(rule.getName() + rule.getQuery() + rule.getDuration())) continue;
                    rulesMap.put(rule.getName() + rule.getQuery() + rule.getDuration(), rule);
                }
            }
            return new ArrayList<PRule>(rulesMap.values());
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String execute(Request request) throws PrometheusApiException {
        ++requestCount;
        String responseBody = null;
        long before = System.currentTimeMillis();
        String code = "0";
        try {
            OkHttpClient httpClient = HttpClientFactory.instantiateHttpClient();
            this.logger.info("PrometheusApi: request[" + requestCount + "] " + request.method().toUpperCase() + " " + request.url().toString());
            Response response = httpClient.newCall(request).execute();
            this.logger.info("PrometheusApi: request[" + requestCount + "] code=" + response.code() + ", success=" + response.isSuccessful());
            code = Integer.toString(response.code());
            if (response.body() != null) {
                responseBody = response.body().string();
                this.logger.debug("PrometheusApi: request[" + requestCount + "] body: " + responseBody);
            }
            response.close();
            DAO.getInstance().removeWarning("prom_api");
        }
        catch (UnknownHostException e) {
            try {
                this.logger.error("PrometheusApi: request[" + requestCount + "] failed: UnknownHostException: " + e.getMessage());
                code = "0";
                DAO.getInstance().addWarning("prom_api", "Prometheus API not reachable");
                throw new PrometheusApiException("Unknown Host");
                catch (SocketTimeoutException e2) {
                    this.logger.error("PrometheusApi: request[" + requestCount + "] failed: SocketTimeoutException: " + e2.getMessage());
                    code = "0";
                    DAO.getInstance().addWarning("prom_api", "Prometheus API not reachable");
                    throw new PrometheusApiException("Timeout");
                }
                catch (SocketException e3) {
                    this.logger.error("PrometheusApi: request[" + requestCount + "] failed: SocketException: " + e3.getMessage());
                    code = "0";
                    DAO.getInstance().addWarning("prom_api", "Prometheus API not reachable");
                    throw new PrometheusApiException("Socket Error");
                }
                catch (SSLException e4) {
                    this.logger.error("PrometheusApi: request[" + requestCount + "] failed: SSLException: " + e4.getMessage());
                    code = "0";
                    DAO.getInstance().addWarning("prom_api", "Prometheus API not reachable");
                    throw new PrometheusApiException("SSL Exception");
                }
                catch (Exception e5) {
                    this.logger.error("PrometheusApi: request[" + requestCount + "] failed: Exception: ", (Throwable)e5);
                    code = "0";
                    DAO.getInstance().addWarning("prom_api", "Prometheus API not reachable");
                    throw new PrometheusApiException("Unknown Exception");
                }
            }
            catch (Throwable throwable) {
                double duration = (double)(System.currentTimeMillis() - before) * 1.0 / 1000.0;
                ((Histogram.Child)AmMetrics.alertmonitor_prom_api_duration_seconds.labels(new String[]{request.method(), code, request.url().toString()})).observe(duration);
                throw throwable;
            }
        }
        double duration = (double)(System.currentTimeMillis() - before) * 1.0 / 1000.0;
        ((Histogram.Child)AmMetrics.alertmonitor_prom_api_duration_seconds.labels(new String[]{request.method(), code, request.url().toString()})).observe(duration);
        return responseBody;
    }
}

