/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import java.text.DecimalFormat;
import java.util.List;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApi;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.KafkaClient;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.util.TaskManager;

@ManagedBean
@SessionScoped
public class UiConfigBean {
    public String getVersion() {
        return AmProps.version;
    }

    public boolean isContainerized() {
        return AmProps.isContainerized;
    }

    public String getLocalIpAddress() {
        return AmProps.localIpAddress;
    }

    public String getRuntimeId() {
        return AmProps.ALERTMONITOR_RUNTIME_ID;
    }

    public String getPromServer() {
        return AmProps.ALERTMONITOR_PROMETHEUS_SERVER;
    }

    public void setPromServer(String server) {
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        AmProps.ALERTMONITOR_PROMETHEUS_SERVER = server;
        LogFactory.getLogger().info("UiConfigBean: prometheus server changed: " + server);
    }

    public void setPsyncInterval(String interval) {
        AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC = Integer.parseInt(interval);
        LogFactory.getLogger().info("UiConfigBean: psync interval changed: " + AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC);
        TaskManager.getInstance().restartPsyncTimer();
    }

    public String getPsyncInterval() {
        return Integer.toString(AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC);
    }

    public void setDataRetention(String time) {
        try {
            AmProps.ALERTMONITOR_DATA_RETENTION_DAYS = Integer.parseInt(time);
            LogFactory.getLogger().info("UiConfigBean: data retention changed: " + AmProps.ALERTMONITOR_DATA_RETENTION_DAYS);
        }
        catch (Exception e) {
            LogFactory.getLogger().error("UiConfigBean: Exception: " + e.getMessage());
        }
    }

    public String getDataRetention() {
        return AmProps.ALERTMONITOR_DATA_RETENTION_DAYS + "";
    }

    public void setMongoDbConnectionString(String mongoDbConnectionString) {
        AmProps.ALERTMONITOR_MONGODB_CONNECTION_STRING = mongoDbConnectionString;
        LogFactory.getLogger().info("UiConfigBean: mongoDB connection string changed: " + AmProps.ALERTMONITOR_MONGODB_CONNECTION_STRING);
        DAO.getInstance().resetDataManager();
    }

    public String getMongoDbConnectionString() {
        return AmProps.ALERTMONITOR_MONGODB_CONNECTION_STRING;
    }

    public void setHttpReadTimeout(String interval) {
        AmProps.ALERTMONITOR_HTTP_CLIENT_READ_TIMEOUT_SEC = Integer.parseInt(interval);
        LogFactory.getLogger().info("UiConfigBean: http client read timeout changed: " + AmProps.ALERTMONITOR_HTTP_CLIENT_READ_TIMEOUT_SEC);
    }

    public String getHttpReadTimeout() {
        return Integer.toString(AmProps.ALERTMONITOR_HTTP_CLIENT_READ_TIMEOUT_SEC);
    }

    public void setKafkaEnabled(boolean kafkaEnabled) {
        AmProps.ALERTMONITOR_KAFKA_ENABLED = kafkaEnabled;
        LogFactory.getLogger().info("UiConfigBean: kafka enabled changed: " + AmProps.ALERTMONITOR_KAFKA_ENABLED);
    }

    public boolean isKafkaEnabled() {
        return AmProps.ALERTMONITOR_KAFKA_ENABLED;
    }

    public void setKafkaServer(String kafkaServer) {
        AmProps.ALERTMONITOR_KAFKA_SERVER = kafkaServer;
        LogFactory.getLogger().info("UiConfigBean: kafka server changed: " + AmProps.ALERTMONITOR_KAFKA_SERVER);
        KafkaClient.getInstance().resetClient();
    }

    public String getKafkaServer() {
        return AmProps.ALERTMONITOR_KAFKA_SERVER;
    }

    public void setKafkaTopic(String kafkaTopic) {
        AmProps.ALERTMONITOR_KAFKA_TOPIC = kafkaTopic;
        LogFactory.getLogger().info("UiConfigBean: kafka topic changed: " + AmProps.ALERTMONITOR_KAFKA_TOPIC);
    }

    public String getKafkaTopic() {
        return AmProps.ALERTMONITOR_KAFKA_TOPIC;
    }

    public String reloadPrometheusAction() {
        LogFactory.getLogger().debug("UiConfigBean: reloadPrometheusAction called");
        try {
            PrometheusApi api = new PrometheusApi();
            api.reload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public long getWhMsgCount() {
        return AmMetrics.webhookMessagesReceivedCount;
    }

    public long getAmMsgCount() {
        return AmMetrics.amMessagesReceivedCount;
    }

    public long getJournalCount() {
        return AmMetrics.journalReceivedCount;
    }

    public long getJournalSize() {
        return DAO.getInstance().getJournalSize();
    }

    public long getAlarmsCount() {
        return AmMetrics.raisingEventCount;
    }

    public long getClearsCount() {
        return AmMetrics.clearingEventCount;
    }

    public String getLastPsyncTime() {
        return Formatter.getFormatedTimestamp(AmMetrics.lastPsyncTimestamp);
    }

    public String getPsyncSuccessCount() {
        return Integer.toString(AmMetrics.psyncSuccessCount);
    }

    public String getPsyncFailedCount() {
        return Integer.toString(AmMetrics.psyncFailedCount);
    }

    public int getActiveAlarmsCount(String severity) {
        return DAO.getInstance().getActiveAlarmsList(severity).size();
    }

    public int getAllActiveAlarmsCount() {
        return DAO.getInstance().getActiveAlerts().size();
    }

    public int getNumberOfAlertsInLastHour() {
        return DAO.getInstance().getDataManager().getNumberOfAlertsInLastHour();
    }

    public String getAlertsPerSecondInLastHour() {
        return DAO.getInstance().getDataManager().getAlertsPerSecondInLastHour();
    }

    public String getBalanceFactor() {
        DecimalFormat df2 = new DecimalFormat("#.##");
        return df2.format(DAO.getInstance().calculateAlertsBalanceFactor());
    }

    public String getStartTime() {
        return Formatter.getFormatedTimestamp(AmProps.startUpTime);
    }

    public String getUpTime() {
        int secUpTotal = (int)((System.currentTimeMillis() - AmProps.startUpTime) / 1000L);
        return Formatter.convertToDHMSFormat(secUpTotal);
    }

    public String getLastEventTime() {
        return Formatter.getFormatedTimestamp(AmMetrics.lastEventTimestamp);
    }

    public String getTimeSinceLastEvent() {
        int secUp = (int)((System.currentTimeMillis() - AmMetrics.lastEventTimestamp) / 1000L);
        return Formatter.convertToDHMSFormat(secUp);
    }

    public List<String> getWarnings() {
        if (DAO.getInstance().getWarnings().size() == 0) {
            return null;
        }
        return DAO.getInstance().getWarnings();
    }
}

