/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.util;

import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.util.AmProps;

public class Formatter {
    public static String toJson(DEvent event) {
        return new Gson().toJson((Object)event);
    }

    public static String getFormatedTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return "n/a";
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat(AmProps.ALERTMONITOR_DATE_FORMAT);
        return sdf.format(cal.getTime());
    }

    public static String convertToDHMSFormat(int seconds) {
        int secRemain = seconds % 60;
        int minTotal = seconds / 60;
        int minRemain = minTotal % 60;
        int hourTotal = minTotal / 60;
        int hourRemain = hourTotal % 60;
        int dayTotal = hourTotal / 24;
        int dayRemain = hourTotal % 24;
        String resp = minRemain + "m " + secRemain + "s";
        if (dayTotal == 0 && hourRemain > 0) {
            resp = hourTotal + "h " + resp;
        }
        if (dayTotal > 0) {
            resp = dayTotal + "d " + dayRemain + "h " + resp;
        }
        return resp;
    }

    public static String stripInstance(String instance) {
        if (instance == null) {
            return instance;
        }
        if (instance.contains("://")) {
            instance = instance.split("://")[1];
        }
        instance = instance.split(":")[0];
        instance = instance.split("/")[0];
        return instance;
    }
}

