/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.util;

import java.util.Timer;
import java.util.TimerTask;
import si.matjazcerkvenik.alertmonitor.data.DbMaintenanceTask;
import si.matjazcerkvenik.alertmonitor.model.PrometheusSyncTask;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;

public class TaskManager {
    private static TaskManager taskManager;
    private Timer pSyncTimer = null;
    private PrometheusSyncTask prometheusSyncTask = null;
    private Timer dbMaintenanceTimer = null;
    private DbMaintenanceTask dbMaintenanceTask = null;

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        if (taskManager == null) {
            taskManager = new TaskManager();
        }
        return taskManager;
    }

    public void restartPsyncTimer() {
        this.stopPsyncTimer();
        if (AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC == 0) {
            LogFactory.getLogger().info("PSync is disabled");
        }
        if (this.prometheusSyncTask == null) {
            LogFactory.getLogger().info("Start periodic sync task with period=" + AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC);
            AmMetrics.alertmonitor_psync_interval_seconds.set((double)AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC);
            if (AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC > 0) {
                this.pSyncTimer = new Timer("PSyncTimer");
                this.prometheusSyncTask = new PrometheusSyncTask();
                this.pSyncTimer.schedule((TimerTask)this.prometheusSyncTask, 5000L, (long)(AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC * 1000));
            }
        }
    }

    public void stopPsyncTimer() {
        if (this.pSyncTimer != null) {
            this.pSyncTimer.cancel();
            this.pSyncTimer = null;
        }
        if (this.prometheusSyncTask != null) {
            this.prometheusSyncTask.cancel();
            this.prometheusSyncTask = null;
        }
    }

    public void startDbMaintenanceTimer() {
        if (this.dbMaintenanceTask == null) {
            LogFactory.getLogger().info("Start DB Maintenance Task");
            this.dbMaintenanceTimer = new Timer("DbMaintenanceTimer");
            this.dbMaintenanceTask = new DbMaintenanceTask();
            this.dbMaintenanceTimer.schedule((TimerTask)this.dbMaintenanceTask, 23000L, 3600000L);
        }
    }

    public void stopDbMaintenanceTimer() {
        if (this.dbMaintenanceTimer != null) {
            this.dbMaintenanceTimer.cancel();
            this.dbMaintenanceTimer = null;
        }
        if (this.dbMaintenanceTask != null) {
            this.dbMaintenanceTask.cancel();
            this.dbMaintenanceTask = null;
        }
    }
}

