/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.web;

import io.prometheus.client.Gauge;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;

public class PrometheusMetricsServlet
extends HttpServlet {
    private static final long serialVersionUID = -5776148450627134391L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AmMetrics.alertmonitor_active_alerts_count.clear();
        for (DEvent n : DAO.getInstance().getActiveAlerts().values()) {
            ((Gauge.Child)AmMetrics.alertmonitor_active_alerts_count.labels(new String[]{n.getAlertname(), n.getSeverity()})).inc();
        }
        AmMetrics.alertmonitor_alerts_balance_factor.set(DAO.getInstance().calculateAlertsBalanceFactor());
        AmMetrics.alertmonitor_last_event_timestamp.set((double)AmMetrics.lastEventTimestamp);
        resp.setStatus(200);
        resp.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (PrintWriter writer = resp.getWriter();){
            TextFormat.write004((Writer)writer, (Enumeration)AmMetrics.registry.filteredMetricFamilySamples(this.parse(req)));
            ((Writer)writer).flush();
        }
    }

    private Set<String> parse(HttpServletRequest req) {
        String[] includedParam = req.getParameterValues("name[]");
        if (includedParam == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(includedParam));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }
}

