/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.simplelogger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import si.matjazcerkvenik.simplelogger.Config;

public class LogWriter {
    private Config config;
    private File f;
    private FileWriter fwStream;
    private BufferedWriter out;
    private PrintWriter pw;
    private int megabyte = 0x100008;
    private long maxSize = 0x100008L;

    public LogWriter(Config config) {
        this.config = config;
        this.maxSize = this.megabyte * config.getMaxSizeMb();
        System.out.println("[SimpleLogger] Config: " + config.toString());
    }

    private void initLogger() {
        if (this.fwStream != null) {
            return;
        }
        this.f = new File(this.config.getFilename());
        this.f.getParentFile().mkdirs();
        if (this.f.exists()) {
            if (this.config.isAppend()) {
                System.out.println("[SimpleLogger] Append output to: " + this.config.getFilename());
            } else {
                System.out.println("[SimpleLogger] Overriding output file: " + this.config.getFilename());
            }
        } else {
            try {
                this.f.createNewFile();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            this.fwStream = new FileWriter(this.config.getFilename(), this.config.isAppend());
            this.pw = new PrintWriter(this.fwStream);
        }
        catch (IOException e) {
            System.err.println("[SimpleLogger] Writing exception");
            e.printStackTrace();
        }
        this.out = new BufferedWriter(this.fwStream);
    }

    public synchronized void writeToFile(String dateFormat, int logLevel, String text, Throwable throwable) {
        if (this.fwStream == null) {
            this.initLogger();
        }
        try {
            if (throwable != null) {
                throwable.printStackTrace(this.pw);
                if (this.config.isVerbose()) {
                    throwable.printStackTrace();
                }
            } else {
                String str = this.getDate(dateFormat) + this.getLevel(logLevel) + text;
                this.out.write(str + "\n");
                if (this.config.isVerbose()) {
                    System.out.println(str);
                }
            }
            this.out.flush();
            if (this.f.length() > this.maxSize) {
                this.startNewLog();
            }
        }
        catch (IOException e) {
            System.out.println("IOException: write");
        }
    }

    private void startNewLog() {
        this.closeLogger();
        this.renameAll();
        this.initLogger();
    }

    private void renameAll() {
        File lastFile = new File(this.config.getFilename() + "." + this.config.getBackup());
        if (lastFile.exists()) {
            lastFile.delete();
        }
        for (int i = this.config.getBackup() - 1; i > 0; --i) {
            File file = new File(this.config.getFilename() + "." + i);
            if (!file.exists()) continue;
            File newFile = new File(this.config.getFilename() + "." + (i + 1));
            file.renameTo(newFile);
        }
        File firstFile = new File(this.config.getFilename());
        if (firstFile.exists()) {
            File newFile = new File(this.config.getFilename() + "." + 1);
            firstFile.renameTo(newFile);
        }
    }

    public void closeLogger() {
        try {
            this.out.close();
            this.out = null;
            this.fwStream.close();
            this.fwStream = null;
        }
        catch (IOException e) {
            System.out.println("IOException: close");
        }
    }

    private String getLevel(int level) {
        if (level == 1) {
            return "TRACE ";
        }
        if (level == 2) {
            return "DEBUG ";
        }
        if (level == 3) {
            return "INFO  ";
        }
        if (level == 4) {
            return "WARN  ";
        }
        if (level == 5) {
            return "ERROR ";
        }
        if (level == 6) {
            return "FATAL ";
        }
        return "";
    }

    private String getDate(String dateFormat) {
        if (dateFormat == null) {
            return "";
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(this.config.getDateFormat());
        return sdf.format(cal.getTime()) + " - ";
    }
}

