/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.simplelogger;

import java.io.Serializable;
import java.util.Properties;
import si.matjazcerkvenik.simplelogger.Config;
import si.matjazcerkvenik.simplelogger.LogWriter;

public class SimpleLogger
implements Serializable {
    private static final long serialVersionUID = -6338153904743837043L;
    private Config config = new Config();
    private LogWriter writer;

    public SimpleLogger() {
        this.writer = new LogWriter(this.config);
    }

    public SimpleLogger(String filename) {
        this.config.setFilename(filename);
        this.writer = new LogWriter(this.config);
    }

    public SimpleLogger(Properties props) {
        this.config.loadProperties(props);
        this.writer = new LogWriter(this.config);
    }

    public void write(String s) {
        this.writer.writeToFile(this.config.getDateFormat(), 99, s, null);
    }

    public void trace(String s) {
        if (this.config.getLogLevel() - 1 < 1) {
            this.writer.writeToFile(this.config.getDateFormat(), 1, s, null);
        }
    }

    public void trace(String s, Throwable t) {
        if (this.config.getLogLevel() - 1 < 1) {
            this.writer.writeToFile(this.config.getDateFormat(), 1, s, t);
        }
    }

    public void debug(String s) {
        if (this.config.getLogLevel() - 1 < 2) {
            this.writer.writeToFile(this.config.getDateFormat(), 2, s, null);
        }
    }

    public void debug(String s, Throwable t) {
        if (this.config.getLogLevel() - 1 < 2) {
            this.writer.writeToFile(this.config.getDateFormat(), 2, s, t);
        }
    }

    public void info(String s) {
        if (this.config.getLogLevel() - 1 < 3) {
            this.writer.writeToFile(this.config.getDateFormat(), 3, s, null);
        }
    }

    public void info(String s, Throwable t) {
        if (this.config.getLogLevel() - 1 < 3) {
            this.writer.writeToFile(this.config.getDateFormat(), 3, s, t);
        }
    }

    public void warn(String s) {
        if (this.config.getLogLevel() - 1 < 4) {
            this.writer.writeToFile(this.config.getDateFormat(), 4, s, null);
        }
    }

    public void warn(String s, Throwable t) {
        if (this.config.getLogLevel() - 1 < 4) {
            this.writer.writeToFile(this.config.getDateFormat(), 4, s, t);
        }
    }

    public void error(String s) {
        if (this.config.getLogLevel() - 1 < 5) {
            this.writer.writeToFile(this.config.getDateFormat(), 5, s, null);
        }
    }

    public void error(String s, Throwable t) {
        if (this.config.getLogLevel() - 1 < 5) {
            this.writer.writeToFile(this.config.getDateFormat(), 5, s, t);
        }
    }

    public void fatal(String s) {
        if (this.config.getLogLevel() - 1 < 6) {
            this.writer.writeToFile(this.config.getDateFormat(), 6, s, null);
        }
    }

    public void fatal(String s, Throwable t) {
        if (this.config.getLogLevel() - 1 < 6) {
            this.writer.writeToFile(this.config.getDateFormat(), 6, s, t);
        }
    }

    public void close() {
        this.writer.closeLogger();
    }

    public void setAppend(boolean append) {
        this.config.setAppend(append);
    }

    public void setLogLevel(int logLevel) {
        this.config.setLogLevel(logLevel);
    }

    public void setDateFormat(String dateFormat) {
        this.config.setDateFormat(dateFormat);
    }

    public void setFilename(String filename) {
        this.config.setFilename(filename);
    }

    public String getFilename() {
        return this.config.getFilename();
    }

    public void setMaxSizeMb(int maxSizeMb) {
        this.config.setMaxSizeMb(maxSizeMb);
    }

    public void setBackup(int backup) {
        this.config.setBackup(backup);
    }

    public void setVerbose(boolean verbose) {
        this.config.setVerbose(verbose);
    }
}

