/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.monitoring.prometheus;

import de.iip_ecosphere.platform.monitoring.MonitoringReceiver;
import de.iip_ecosphere.platform.monitoring.prometheus.IipEcospherePrometheusExporter;
import de.iip_ecosphere.platform.monitoring.prometheus.PrometheusLifecycleDescriptor;
import de.iip_ecosphere.platform.monitoring.prometheus.PrometheusMonitoringSetup;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.util.HashSet;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.monitoring.AbstractMonitoringReceiverTest;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class PrometheusLifecycleDescriptorTest
extends AbstractMonitoringReceiverTest {
    @BeforeClass
    public static void setup() {
        TestWithQpid.addPlugin();
        TestWithQpid.loadPlugins();
    }

    @Test
    public void testDescriptor() {
        MyMonitoringRecieverLifecycle mrl = new MyMonitoringRecieverLifecycle();
        this.runScenario(mrl);
    }

    protected Server createBroker(ServerAddress broker) {
        return TestWithQpid.fromPlugin((ServerAddress)broker);
    }

    protected int getSleepTime() {
        return 10000;
    }

    private class MyMonitoringRecieverLifecycle
    implements AbstractMonitoringReceiverTest.MonitoringRecieverLifecycle {
        private PrometheusLifecycleDescriptor desc;
        private MyIipPrometheusExporter exporter;

        private MyMonitoringRecieverLifecycle() {
        }

        public void start(TransportSetup transSetup) {
            PrometheusMonitoringSetup.getInstance().setTransport(transSetup);
            ServiceLoader loader = ServiceLoaderUtils.load(LifecycleDescriptor.class);
            Optional<PrometheusLifecycleDescriptor> pml = ServiceLoaderUtils.stream((ServiceLoader)loader).filter(d -> d instanceof PrometheusLifecycleDescriptor).map(PrometheusLifecycleDescriptor.class::cast).findFirst();
            Assert.assertTrue((boolean)pml.isPresent());
            this.desc = pml.get();
            this.exporter = new MyIipPrometheusExporter();
            this.desc.setExporterSupplier(() -> this.exporter);
            this.desc.startup(new String[0]);
            System.out.println("Sleeping to be on the safe side...");
            TimeUtils.sleep((int)30000);
            IipEcospherePrometheusExporter exp = this.desc.getExporter();
            Assert.assertNotNull((Object)exp);
        }

        public void stop() {
            this.desc.shutdown();
            this.exporter.doAsserts();
        }
    }

    private class MyIipPrometheusExporter
    extends IipEcospherePrometheusExporter {
        private String createdExporterId;
        private Set<String> receivedMeterStreams = new HashSet<String>();
        private int statusCount;
        private int meterRecCount;
        private int meterCount;

        private MyIipPrometheusExporter() {
        }

        protected MonitoringReceiver.Exporter createExporter(String id) {
            this.createdExporterId = id;
            return super.createExporter(id);
        }

        protected void notifyMeterReception(String stream, String id, JsonObject obj) {
            super.notifyMeterReception(stream, id, obj);
            this.receivedMeterStreams.add(stream);
            ++this.meterRecCount;
        }

        protected void notifyStatusReceived(StatusMessage msg) {
            super.notifyStatusReceived(msg);
            ++this.statusCount;
        }

        protected void notifyMeterAdded(Meter meter) {
            super.notifyMeterAdded(meter);
            if (meter != null) {
                ++this.meterCount;
            }
        }

        protected void doAsserts() {
            String deviceId = Id.getDeviceId();
            Assert.assertEquals((Object)deviceId, (Object)this.createdExporterId);
            Assert.assertTrue((boolean)this.receivedMeterStreams.contains("EcsMetrics"));
            Assert.assertTrue((boolean)this.receivedMeterStreams.contains("ServiceMetrics"));
            Assert.assertTrue((this.statusCount >= 2 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterRecCount > 0 ? 1 : 0) != 0);
            Assert.assertTrue((this.meterCount > 0 ? 1 : 0) != 0);
        }
    }
}

