/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.model.alertmanager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.alertmanager.AmAlert;
import si.matjazcerkvenik.alertmonitor.model.alertmanager.AmAlertMessage;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.web.WebhookMessage;

public class AlertmanagerProcessor {
    public static void processWebhookMessage(WebhookMessage wm) throws Exception {
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        AmAlertMessage am = (AmAlertMessage)gson.fromJson(wm.getBody(), AmAlertMessage.class);
        LogFactory.getLogger().debug(am.toString());
        LogFactory.getLogger().info("AlertmanagerProcessor: alerts received: " + am.getAlerts().size());
        List<DEvent> eventList = AlertmanagerProcessor.convertToDevent(wm, am);
        DAO.getInstance().synchronizeAlerts(eventList, false);
    }

    private static List<DEvent> convertToDevent(WebhookMessage m, AmAlertMessage am) {
        ArrayList<DEvent> eventList = new ArrayList<DEvent>();
        for (AmAlert a : am.getAlerts()) {
            DEvent e = new DEvent();
            e.setTimestamp(System.currentTimeMillis());
            e.setFirstTimestamp(e.getTimestamp());
            e.setLastTimestamp(e.getTimestamp());
            e.setSource(m.getRemoteHost());
            e.setAlertname(a.getLabels().getOrDefault("alertname", "-unknown-"));
            e.setUserAgent(m.getHeaderMap().getOrDefault("user-agent", "-"));
            e.setInfo(a.getLabels().getOrDefault("info", "-"));
            e.setInstance(a.getLabels().getOrDefault("instance", "-"));
            e.setHostname(Formatter.stripInstance(e.getInstance()));
            e.setNodename(a.getLabels().getOrDefault("nodename", e.getInstance()));
            e.setJob(a.getLabels().getOrDefault("job", "-"));
            e.setTags(a.getLabels().getOrDefault("tags", ""));
            e.setSeverity(a.getLabels().getOrDefault("severity", "indeterminate"));
            e.setPriority(a.getLabels().getOrDefault("priority", "low"));
            e.setGroup(a.getLabels().getOrDefault("group", "unknown"));
            e.setEventType(a.getLabels().getOrDefault("eventType", "5"));
            e.setProbableCause(a.getLabels().getOrDefault("probableCause", "1024"));
            e.setCurrentValue(a.getAnnotations().getOrDefault("currentValue", "-"));
            e.setUrl(a.getLabels().getOrDefault("url", ""));
            if (a.getLabels().containsKey("description")) {
                e.setDescription(a.getLabels().getOrDefault("description", "-"));
            } else {
                e.setDescription(a.getAnnotations().getOrDefault("description", "-"));
            }
            e.setStatus(a.getStatus());
            e.setGeneratorUrl(a.getGeneratorURL());
            String[] lblArray = AmProps.ALERTMONITOR_PROMETHEUS_ID_LABELS.split(",");
            String s = "{";
            for (int i = 0; i < lblArray.length; ++i) {
                s = s + lblArray[i].trim() + "=\"" + a.getLabels().getOrDefault(lblArray[i].trim(), "-") + "\", ";
            }
            s = s.substring(0, s.length() - 2) + "}";
            e.setPrometheusId(s);
            e.setOtherLabels(a.getLabels());
            if (a.getStatus().equalsIgnoreCase("resolved")) {
                e.setSeverity("clear");
            }
            if (!e.getSeverity().equals("clear")) {
                e.setTags(e.getTags() + "," + e.getSeverity());
            }
            e.setTags(e.getTags() + "," + e.getPriority());
            e.setNodename(AlertmanagerProcessor.substitute(e.getNodename()));
            e.setInfo(AlertmanagerProcessor.substitute(e.getInfo()));
            e.setDescription(AlertmanagerProcessor.substitute(e.getDescription()));
            e.setTags(AlertmanagerProcessor.substitute(e.getTags()));
            e.setUrl(AlertmanagerProcessor.substitute(e.getUrl()));
            e.generateUID();
            e.generateCID();
            eventList.add(e);
            LogFactory.getLogger().info("AlertmanagerProcessor: " + e.toString());
        }
        return eventList;
    }

    public static String substitute(String s) {
        if (s == null || !s.contains("${")) {
            return s;
        }
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            s = s.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return s;
    }
}

