/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring.prometheus;

import de.iip_ecosphere.platform.monitoring.prometheus.PrometheusMonitoringSetup;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.status.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import si.matjazcerkvenik.alertmonitor.data.DAO;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.model.alertmanager.AlertmanagerProcessor;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PAlert;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApi;
import si.matjazcerkvenik.alertmonitor.model.prometheus.PrometheusApiException;
import si.matjazcerkvenik.alertmonitor.util.AmMetrics;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.Formatter;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.util.TaskManager;

public class AlertManagerImporter {
    private static Logger logger = LoggerFactory.getLogger(AlertManagerImporter.class);
    private Timer timer;
    private SyncTask syncTask;

    public void start() {
        LogFactory.getLogger().setLogLevel(4);
        PrometheusMonitoringSetup setup = PrometheusMonitoringSetup.getInstance();
        AmProps.ALERTMONITOR_PROMETHEUS_SERVER = setup.getPrometheus().getAlertMgr().getServerAddress().toServerUri();
        AmProps.ALERTMONITOR_HTTP_CLIENT_READ_TIMEOUT_SEC = 2;
        AmProps.ALERTMONITOR_KAFKA_ENABLED = false;
        AmProps.ALERTMONITOR_MONGODB_ENABLED = false;
        AmProps.ALERTMONITOR_PSYNC_INTERVAL_SEC = 1;
        this.syncTask = new SyncTask();
        this.timer = new Timer("IIP Prometheus alert manager sync task");
        this.timer.schedule((TimerTask)this.syncTask, 0L, 1000L);
    }

    private void synchronizeAlerts(List<DEvent> alertList, boolean psync) {
        for (DEvent e : alertList) {
            Alert alert = new Alert();
            e.setUid(e.getUid());
            e.setCorrelationId(e.getCorrelationId());
            e.setTimestamp(e.getTimestamp());
            e.setFirstTimestamp(e.getFirstTimestamp());
            e.setLastTimestamp(e.getLastTimestamp());
            e.setClearTimestamp(e.getClearTimestamp());
            e.setAlertname(e.getAlertname());
            e.setSource(e.getSource());
            e.setInstance(e.getInstance());
            e.setInfo(e.getInfo());
            e.setTags(e.getTags());
            e.setSeverity(e.getSeverity());
            e.setPriority(e.getPriority());
            e.setEventType(e.getEventType());
            e.setProbableCause(e.getProbableCause());
            e.setCurrentValue(e.getCurrentValue());
            e.setUrl(e.getUrl());
            e.setDescription(e.getDescription());
            e.setStatus(e.getStatus());
            e.setRuleExpression(e.getRuleExpression());
            e.setRuleTimeLimit(e.getRuleTimeLimit());
            Transport.sendAlert((Alert)alert);
        }
    }

    public void stop() {
        if (null != this.syncTask) {
            this.syncTask.cancel();
            this.syncTask = null;
        }
        if (null != this.timer) {
            this.timer.purge();
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class SyncTask
    extends TimerTask {
        private PrometheusApi api = new PrometheusApi();

        private SyncTask() {
        }

        @Override
        public void run() {
            AmMetrics.lastPsyncTimestamp = System.currentTimeMillis();
            try {
                List activeAlerts = this.api.alerts();
                if (activeAlerts == null) {
                    logger.error("PSYNC: null response returned");
                    logger.debug("PSYNC: === Periodic synchronization complete ===");
                    ++AmMetrics.psyncFailedCount;
                    DAO.getInstance().addWarning("psync", "Synchronization is failing");
                    return;
                }
                ArrayList<DEvent> pSyncAlerts = new ArrayList<DEvent>();
                for (PAlert alert : activeAlerts) {
                    logger.debug(alert.toString());
                    DEvent e = this.createDEvent(alert);
                    String[] lblArray = AmProps.ALERTMONITOR_PROMETHEUS_ID_LABELS.split(",");
                    Object s = "{";
                    for (int i = 0; i < lblArray.length; ++i) {
                        s = (String)s + lblArray[i].trim() + "=\"" + alert.getLabels().getOrDefault(lblArray[i].trim(), "-") + "\", ";
                    }
                    s = ((String)s).substring(0, ((String)s).length() - 2) + "}";
                    e.setPrometheusId((String)s);
                    e.setOtherLabels(alert.getLabels());
                    if (!alert.getState().equals("firing")) continue;
                    e.setStatus("firing");
                    if (!e.getSeverity().equals("clear")) {
                        e.setTags(e.getTags() + "," + e.getSeverity());
                    }
                    e.setTags(e.getTags() + "," + e.getPriority());
                    e.setNodename(AlertmanagerProcessor.substitute((String)e.getNodename()));
                    e.setInfo(AlertmanagerProcessor.substitute((String)e.getInfo()));
                    e.setDescription(AlertmanagerProcessor.substitute((String)e.getDescription()));
                    e.setTags(AlertmanagerProcessor.substitute((String)e.getTags()));
                    e.setUrl(AlertmanagerProcessor.substitute((String)e.getUrl()));
                    e.generateUID();
                    e.generateCID();
                    logger.debug("PSYNC: " + e.toString());
                    pSyncAlerts.add(e);
                }
                AlertManagerImporter.this.synchronizeAlerts(pSyncAlerts, true);
                ++AmMetrics.psyncSuccessCount;
                AmMetrics.alertmonitor_psync_success.set(1.0);
                DAO.getInstance().removeWarning("psync");
            }
            catch (PrometheusApiException e) {
                logger.error("PSYNC: failed to synchronize alarms; root cause: " + e.getMessage());
                ++AmMetrics.psyncFailedCount;
                AmMetrics.alertmonitor_psync_success.set(0.0);
                DAO.getInstance().addWarning("psync", "Synchronization is failing");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        @Override
        public boolean cancel() {
            DAO.getInstance().getDataManager().close();
            TaskManager.getInstance().stopDbMaintenanceTimer();
            return super.cancel();
        }

        private DEvent createDEvent(PAlert alert) {
            DEvent e = new DEvent();
            e.setTimestamp(System.currentTimeMillis());
            e.setAlertname(alert.getLabels().getOrDefault("alertname", "-unknown-"));
            e.setSource("PSYNC");
            e.setUserAgent("");
            e.setInstance(alert.getLabels().getOrDefault("instance", "-"));
            e.setHostname(Formatter.stripInstance((String)e.getInstance()));
            e.setNodename(alert.getLabels().getOrDefault("nodename", e.getInstance()));
            e.setInfo(alert.getLabels().getOrDefault("info", "-"));
            e.setJob(alert.getLabels().getOrDefault("job", "-"));
            e.setTags(alert.getLabels().getOrDefault("tags", ""));
            e.setSeverity(alert.getLabels().getOrDefault("severity", "indeterminate"));
            e.setPriority(alert.getLabels().getOrDefault("priority", "low"));
            e.setGroup(alert.getLabels().getOrDefault("group", "unknown"));
            e.setEventType(alert.getLabels().getOrDefault("eventType", "5"));
            e.setProbableCause(alert.getLabels().getOrDefault("probableCause", "1024"));
            e.setCurrentValue(alert.getAnnotations().getOrDefault("currentValue", "-"));
            e.setUrl(alert.getLabels().getOrDefault("url", ""));
            if (alert.getLabels().containsKey("description")) {
                e.setDescription(alert.getLabels().getOrDefault("description", "-"));
            } else {
                e.setDescription(alert.getAnnotations().getOrDefault("description", "-"));
            }
            return e;
        }
    }
}

