/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ProtectedViewException;
import javax.faces.application.ViewExpiredException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.flow.FlowHandler;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreViewPhase
extends Phase {
    private static final String WEBAPP_ERROR_PAGE_MARKER = "javax.servlet.error.message";
    private static final Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private WebConfiguration webConfig;
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";

    @Override
    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    @Override
    public void doPhase(FacesContext context, Lifecycle lifecycle, ListIterator<PhaseListener> listeners) {
        Util.getViewHandler(context).initView(context);
        super.doPhase(context, lifecycle, listeners);
        this.notifyAfter(context, lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(FacesContext facesContext) throws FacesException {
        block27: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Entering RestoreViewPhase");
            }
            if (null == facesContext) {
                throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR", new Object[0]));
            }
            UIViewRoot viewRoot = facesContext.getViewRoot();
            if (viewRoot != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Found a pre created view in FacesContext");
                }
                facesContext.getViewRoot().setLocale(facesContext.getExternalContext().getRequestLocale());
                this.deliverPostRestoreStateEvent(facesContext);
                if (facesContext.isPostback()) return;
                facesContext.renderResponse();
                return;
            }
            FacesException thrownException = null;
            try {
                try {
                    boolean isPostBack;
                    Map requestMap = facesContext.getExternalContext().getRequestMap();
                    String viewId = (String)requestMap.get("javax.servlet.include.path_info");
                    if (viewId == null) {
                        viewId = facesContext.getExternalContext().getRequestPathInfo();
                    }
                    if (viewId == null) {
                        viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
                    }
                    if (viewId == null) {
                        viewId = facesContext.getExternalContext().getRequestServletPath();
                    }
                    if (viewId == null) {
                        throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR", new Object[0]));
                    }
                    ViewHandler viewHandler = Util.getViewHandler(facesContext);
                    boolean bl = isPostBack = facesContext.isPostback() && !RestoreViewPhase.isErrorPage(facesContext);
                    if (isPostBack) {
                        facesContext.setProcessingEvents(false);
                        viewRoot = viewHandler.restoreView(facesContext, viewId);
                        if (viewRoot == null) {
                            if (!this.is11CompatEnabled(facesContext)) {
                                Object[] params = new Object[]{viewId};
                                throw new ViewExpiredException(MessageUtils.getExceptionMessageString("com.sun.faces.RESTORE_VIEW_ERROR", params), viewId);
                            }
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.fine("Postback: recreating a view for " + viewId);
                            }
                            viewRoot = viewHandler.createView(facesContext, viewId);
                            facesContext.renderResponse();
                        }
                        facesContext.setViewRoot(viewRoot);
                        facesContext.setProcessingEvents(true);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Postback: restored view for " + viewId);
                        }
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("New request: creating a view for " + viewId);
                        }
                        String derivedViewId = viewHandler.deriveLogicalViewId(facesContext, viewId);
                        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, derivedViewId);
                        this.maybeTakeProtectedViewAction(facesContext, viewHandler, vdl, viewId);
                        ViewMetadata metadata = null;
                        if (vdl != null && (metadata = vdl.getViewMetadata(facesContext, viewId)) != null && !ViewMetadata.hasMetadata((UIViewRoot)(viewRoot = metadata.createMetadataView(facesContext)))) {
                            facesContext.renderResponse();
                        }
                        if (null == vdl || null == metadata) {
                            facesContext.renderResponse();
                        }
                        if (null == viewRoot) {
                            viewRoot = Util.getViewHandler(facesContext).createView(facesContext, viewId);
                        }
                        facesContext.setViewRoot(viewRoot);
                        assert (null != viewRoot);
                    }
                    Object var12_13 = null;
                    if (null != thrownException) throw thrownException;
                }
                catch (Throwable fe) {
                    thrownException = fe instanceof FacesException ? (FacesException)fe : new FacesException(fe);
                    Object var12_14 = null;
                    if (null != thrownException) throw thrownException;
                    FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                    if (null != flowHandler) {
                        flowHandler.clientWindowTransition(facesContext);
                    }
                    this.deliverPostRestoreStateEvent(facesContext);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (null != thrownException) throw thrownException;
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                if (null != flowHandler) {
                    flowHandler.clientWindowTransition(facesContext);
                }
                this.deliverPostRestoreStateEvent(facesContext);
                throw throwable;
            }
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            if (null != flowHandler) {
                flowHandler.clientWindowTransition(facesContext);
            }
            this.deliverPostRestoreStateEvent(facesContext);
        }
        if (!LOGGER.isLoggable(Level.FINE)) return;
        LOGGER.fine("Exiting RestoreViewPhase");
    }

    private void maybeTakeProtectedViewAction(FacesContext context, ViewHandler viewHandler, ViewDeclarationLanguage vdl, String viewId) {
        Set urlPatterns = viewHandler.getProtectedViewsUnmodifiable();
        boolean currentViewIsProtected = this.isProtectedView(viewId, urlPatterns);
        if (currentViewIsProtected) {
            String origin;
            boolean originIsInProtectedSet;
            String referer;
            boolean refererIsInProtectedSet;
            ExternalContext extContext = context.getExternalContext();
            Map headers = extContext.getRequestHeaderMap();
            String rkId = viewHandler.calculateRenderKitId(context);
            ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, rkId);
            String incomingSecretKeyValue = (String)extContext.getRequestParameterMap().get("javax.faces.Token");
            if (null != incomingSecretKeyValue) {
                try {
                    incomingSecretKeyValue = URLEncoder.encode(incomingSecretKeyValue, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "Unable to re-encode value of request parameter javax.faces.Token:" + incomingSecretKeyValue, e);
                    }
                    incomingSecretKeyValue = null;
                }
            }
            String correctSecretKeyValue = rsm.getCryptographicallyStrongTokenFromSession(context);
            if (null == incomingSecretKeyValue || !correctSecretKeyValue.equals(incomingSecretKeyValue)) {
                LOGGER.log(Level.SEVERE, "correctSecretKeyValue = {0} incomingSecretKeyValue = {1}", new Object[]{correctSecretKeyValue, incomingSecretKeyValue});
                throw new ProtectedViewException();
            }
            String sep = "/";
            if (headers.containsKey("Referer") && !(refererIsInProtectedSet = this.isProtectedView(referer = (String)headers.get("Referer"), urlPatterns))) {
                boolean refererOriginatesInThisWebapp = false;
                try {
                    refererOriginatesInThisWebapp = this.originatesInWebapp(context, referer, vdl);
                }
                catch (URISyntaxException ue) {
                    throw new ProtectedViewException((Throwable)ue);
                }
                if (!refererOriginatesInThisWebapp) {
                    String message = FacesLogger.LIFECYCLE.interpolateMessage(context, "jsf.lifecycle.invalid.referer", new String[]{referer, viewId});
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, message);
                    }
                    throw new ProtectedViewException(message);
                }
            }
            if (headers.containsKey("Origin") && !(originIsInProtectedSet = this.isProtectedView(origin = (String)headers.get("Origin"), urlPatterns))) {
                boolean originOriginatesInThisWebapp = false;
                try {
                    originOriginatesInThisWebapp = this.originatesInWebapp(context, origin, vdl);
                }
                catch (URISyntaxException ue) {
                    throw new ProtectedViewException((Throwable)ue);
                }
                if (!originOriginatesInThisWebapp) {
                    String message = FacesLogger.LIFECYCLE.interpolateMessage(context, "jsf.lifecycle.invalid.origin", new String[]{origin, viewId});
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, message);
                    }
                    throw new ProtectedViewException(message);
                }
            }
        }
    }

    private boolean isProtectedView(String viewToCheck, Set<String> urlPatterns) {
        boolean isProtected = false;
        for (String cur : urlPatterns) {
            if (!cur.equals(viewToCheck)) continue;
            isProtected = true;
            break;
        }
        return isProtected;
    }

    private boolean originatesInWebapp(FacesContext context, String view, ViewDeclarationLanguage vdl) throws URISyntaxException {
        boolean doesOriginate = false;
        ExternalContext extContext = context.getExternalContext();
        String sep = "/";
        URI uri = null;
        String path = null;
        boolean isAbsoluteURI = view.matches("^[a-z]+://.*");
        if (!isAbsoluteURI) {
            URI absoluteURI = null;
            URI relativeURI = null;
            String base = extContext.getRequestScheme() + ":" + sep + sep + extContext.getRequestServerName() + ":" + extContext.getRequestServerPort();
            absoluteURI = new URI(base);
            relativeURI = new URI(view);
            uri = absoluteURI.resolve(relativeURI);
        }
        boolean hostsMatch = false;
        boolean portsMatch = false;
        boolean contextPathsMatch = false;
        boolean originatesInThisWebapp = false;
        if (null == uri) {
            uri = new URI(view);
        }
        hostsMatch = null == uri.getHost() ? false : uri.getHost().equals(extContext.getRequestServerName());
        portsMatch = -1 == uri.getPort() ? false : uri.getPort() == extContext.getRequestServerPort();
        path = uri.getPath();
        contextPathsMatch = path.contains(extContext.getApplicationContextPath());
        boolean bl = doesOriginate = hostsMatch && portsMatch && contextPathsMatch;
        if (!doesOriginate) {
            int idx = path.lastIndexOf(sep);
            if (-1 != idx) {
                path = path.substring(idx);
            }
            doesOriginate = null != path && vdl.viewExists(context, path);
        }
        return doesOriginate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverPostRestoreStateEvent(FacesContext facesContext) throws FacesException {
        UIViewRoot root = facesContext.getViewRoot();
        final PostRestoreStateEvent postRestoreStateEvent = new PostRestoreStateEvent((UIComponent)root);
        try {
            try {
                facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
                facesContext.getApplication().publishEvent(facesContext, PostRestoreStateEvent.class, (Object)root);
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, hints);
                root.visitTree(visitContext, new VisitCallback(){

                    public VisitResult visit(VisitContext context, UIComponent target) {
                        postRestoreStateEvent.setComponent(target);
                        target.processEvent((ComponentSystemEvent)postRestoreStateEvent);
                        return VisitResult.ACCEPT;
                    }
                });
            }
            catch (AbortProcessingException e) {
                facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)new ExceptionQueuedEventContext(facesContext, (Throwable)e, null, PhaseId.RESTORE_VIEW));
                Object var7_8 = null;
                facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
                return;
            }
            Object var7_7 = null;
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
            throw throwable;
        }
    }

    private void notifyAfter(FacesContext context, Lifecycle lifecycle) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (null == viewRoot) {
            return;
        }
        MethodExpression afterPhase = viewRoot.getAfterPhaseListener();
        if (null != afterPhase) {
            try {
                PhaseEvent event = new PhaseEvent(context, PhaseId.RESTORE_VIEW, lifecycle);
                afterPhase.invoke(context.getELContext(), new Object[]{event});
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "severe.component.unable_to_process_expression", new Object[]{afterPhase.getExpressionString(), "afterPhase"});
                }
                return;
            }
        }
    }

    private static boolean isErrorPage(FacesContext context) {
        return context.getExternalContext().getRequestMap().get(WEBAPP_ERROR_PAGE_MARKER) != null;
    }

    private WebConfiguration getWebConfig(FacesContext context) {
        if (this.webConfig == null) {
            this.webConfig = WebConfiguration.getInstance(context.getExternalContext());
        }
        return this.webConfig;
    }

    private boolean is11CompatEnabled(FacesContext context) {
        return this.getWebConfig(context).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableRestoreView11Compatibility);
    }
}

