/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import si.matjazcerkvenik.alertmonitor.model.DEvent;

public class Target {
    private String id;
    private String hostname;
    private boolean smartTarget;
    private String job;
    private boolean up;
    private Map<String, DEvent> alerts = new HashMap<String, DEvent>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean isSmartTarget() {
        return this.smartTarget;
    }

    public void setSmartTarget(boolean smartTarget) {
        this.smartTarget = smartTarget;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public boolean isUp() {
        return this.up;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public void setHealth(String health) {
        if (health.equalsIgnoreCase("up")) {
            this.up = true;
            return;
        }
        this.up = false;
    }

    public List<DEvent> getAlerts() {
        return new ArrayList<DEvent>(this.alerts.values());
    }

    public List<DEvent> getAlertsBySeverity(String severity) {
        return this.alerts.values().stream().filter(alert -> alert.getSeverity().toLowerCase().equalsIgnoreCase(severity)).collect(Collectors.toList());
    }

    public void addAlert(DEvent notification) {
        if (!this.alerts.containsKey(notification.getUid())) {
            this.alerts.put(notification.getUid(), notification);
        }
    }

    public String toString() {
        return "Target{id='" + this.id + '\'' + ", hostname='" + this.hostname + '\'' + ", alerts=" + this.alerts + '}';
    }
}

