/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.mongodb;

import com.mongodb.event.CommandEvent;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.micrometer.core.annotation.Incubating;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.concurrent.TimeUnit;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsCommandListener
implements CommandListener {
    private final MeterRegistry registry;

    public MongoMetricsCommandListener(MeterRegistry registry) {
        this.registry = registry;
    }

    public void commandStarted(CommandStartedEvent commandStartedEvent) {
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        this.timeCommand((CommandEvent)event, "SUCCESS", event.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    public void commandFailed(CommandFailedEvent event) {
        this.timeCommand((CommandEvent)event, "FAILED", event.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    private void timeCommand(CommandEvent event, String status, long elapsedTimeInNanoseconds) {
        Timer.builder("mongodb.driver.commands").description("Timer of mongodb commands").tag("command", event.getCommandName()).tag("cluster.id", event.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()).tag("server.address", event.getConnectionDescription().getServerAddress().toString()).tag("status", status).register(this.registry).record(elapsedTimeInNanoseconds, TimeUnit.NANOSECONDS);
    }
}

