/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.data;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import si.matjazcerkvenik.alertmonitor.data.IDataManager;
import si.matjazcerkvenik.alertmonitor.model.DEvent;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;
import si.matjazcerkvenik.alertmonitor.web.WebhookMessage;
import si.matjazcerkvenik.simplelogger.SimpleLogger;

public class InMemoryDataManager
implements IDataManager {
    private static SimpleLogger logger = LogFactory.getLogger();
    private List<WebhookMessage> webhookMessages = new LinkedList<WebhookMessage>();
    private List<DEvent> journal = new LinkedList<DEvent>();

    public InMemoryDataManager() {
        logger.info("InMemoryDataManager initialized");
    }

    @Override
    public void addWebhookMessage(WebhookMessage message) {
        this.webhookMessages.add(message);
    }

    @Override
    public List<WebhookMessage> getWebhookMessages() {
        return this.webhookMessages;
    }

    @Override
    public void addToJournal(List<DEvent> events) {
        this.journal.addAll(events);
        for (DEvent e : events) {
            LogFactory.getLogger().info("InMemoryDataManager: adding to journal: uid=" + e.getUid());
        }
    }

    @Override
    public List<DEvent> getJournal() {
        return this.journal;
    }

    @Override
    public long getJournalSize() {
        return this.journal.size();
    }

    @Override
    public int getNumberOfAlertsInLastHour() {
        List result = this.journal.stream().filter(notif -> this.checkIfYoungerThan((DEvent)notif, 60)).collect(Collectors.toList());
        return result.size();
    }

    @Override
    public String getAlertsPerSecondInLastHour() {
        List result = this.journal.stream().filter(notif -> this.checkIfYoungerThan((DEvent)notif, 60)).collect(Collectors.toList());
        int count = result.size();
        double perSecond = (double)count / 3600.0;
        DecimalFormat df2 = new DecimalFormat("#.###");
        return df2.format(perSecond);
    }

    private boolean checkIfYoungerThan(DEvent event, int minutes) {
        return System.currentTimeMillis() - event.getTimestamp() < (long)(minutes * 60 * 1000);
    }

    @Override
    public DEvent getEvent(String id) {
        for (DEvent n : this.journal) {
            if (!n.getUid().equals(id)) continue;
            return n;
        }
        return null;
    }

    @Override
    public void cleanDB() {
        Iterator<Object> it = this.webhookMessages.iterator();
        while (it.hasNext()) {
            if (it.next().getTimestamp() >= System.currentTimeMillis() - 86400000L) continue;
            it.remove();
        }
        it = this.journal.iterator();
        while (it.hasNext()) {
            if (((DEvent)it.next()).getTimestamp() >= System.currentTimeMillis() - (long)(AmProps.ALERTMONITOR_DATA_RETENTION_DAYS * 24 * 3600 * 1000)) continue;
            it.remove();
        }
    }

    @Override
    public void handleAlarmClearing(DEvent clearEvent) {
        for (DEvent jEvent : this.journal) {
            if (!jEvent.getCorrelationId().equals(clearEvent.getCorrelationId()) || jEvent.getClearTimestamp() != 0L) continue;
            jEvent.setClearTimestamp(clearEvent.getTimestamp());
            jEvent.setClearUid(clearEvent.getUid());
        }
    }

    @Override
    public void close() {
    }
}

