/*
 * Decompiled with CFR 0.152.
 */
package si.matjazcerkvenik.alertmonitor.util;

import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import si.matjazcerkvenik.alertmonitor.util.AmProps;
import si.matjazcerkvenik.alertmonitor.util.LogFactory;

public class KafkaClient {
    private static int kafkaClientsCount = 0;
    private int clientId;
    private Properties props = new Properties();
    private Producer<String, String> producer;
    private long msgCounter = 0L;
    private static KafkaClient kafkaClient;

    public KafkaClient() {
        this.clientId = kafkaClientsCount++;
        this.props.put("bootstrap.servers", AmProps.ALERTMONITOR_KAFKA_SERVER);
        this.props.put("acks", "0");
        this.props.put("retries", (Object)0);
        this.props.put("batch.size", (Object)16384);
        this.props.put("linger.ms", (Object)1);
        this.props.put("buffer.memory", (Object)0x2000000);
        this.props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(this.props);
    }

    public static KafkaClient getInstance() {
        if (kafkaClient == null) {
            kafkaClient = new KafkaClient();
        }
        return kafkaClient;
    }

    public void publish(String topic, String json) {
        this.producer.send(new ProducerRecord(topic, (Object)Long.toString(this.msgCounter++), (Object)json));
        LogFactory.getLogger().info("kafka publish to topic: " + topic + ": [" + this.props.get("bootstrap.servers") + "]: " + json);
    }

    public void resetClient() {
        this.producer.close();
        kafkaClient = null;
    }
}

