/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.metrics.micrometer;

import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerTag;
import de.oktoflow.platform.support.metrics.micrometer.MicrometerUtils;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.List;

class AbstractMeter<M extends io.micrometer.core.instrument.Meter>
implements Meter {
    private M meter;
    private MicrometerId id;

    protected AbstractMeter(M meter) {
        this.meter = meter;
    }

    protected M getMeter() {
        return this.meter;
    }

    public String getName() {
        return this.meter.getId().getName();
    }

    public int hashCode() {
        return this.meter.hashCode();
    }

    public boolean equals(Object other) {
        return other == this || this.meter.equals(other instanceof AbstractMeter ? ((AbstractMeter)other).getMeter() : other);
    }

    public Meter.Id getId() {
        if (null == this.id) {
            this.id = new MicrometerId(this.meter.getId());
        }
        return this.id;
    }

    public Iterable<Measurement> measure() {
        return MicrometerUtils.mmWrapMeasurementIterable(this.meter.measure());
    }

    static class MicrometerId
    implements Meter.Id {
        private Meter.Id id;
        private List<de.iip_ecosphere.platform.support.metrics.Tag> tags;

        MicrometerId(Meter.Id id) {
            this.id = id;
        }

        public String getName() {
            return this.id.getName();
        }

        private void initTags() {
            if (null == this.tags && this.id.getTags() != null) {
                this.tags = new ArrayList<de.iip_ecosphere.platform.support.metrics.Tag>();
                for (Tag t : this.id.getTags()) {
                    this.tags.add(new MicrometerTag(t));
                }
            }
        }

        public List<de.iip_ecosphere.platform.support.metrics.Tag> getTags() {
            this.initTags();
            return this.tags;
        }

        public Iterable<de.iip_ecosphere.platform.support.metrics.Tag> getTagsAsIterable() {
            this.initTags();
            return this.tags;
        }

        public String getTag(String key) {
            return this.id.getTag(key);
        }

        public String getBaseUnit() {
            return this.id.getBaseUnit();
        }

        public String getDescription() {
            return this.id.getDescription();
        }

        public String toString() {
            return this.id.toString();
        }

        public Meter.Type getType() {
            return MicrometerUtils.typeValue(this.id.getType());
        }

        public Meter.Id getId() {
            return this.id;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            return other == this || this.id.equals(other instanceof MicrometerId ? ((MicrometerId)other).id : other);
        }
    }
}

