/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.monitoring;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.Alert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class MonitoringAas
implements AasContributor {
    public static final String SUBMODEL_MONITORING = "Monitoring";
    public static final String SMEC_ALERTS = "Alerts";
    public static final String PROPERTY_ALERT_UID = "Uid";
    public static final String PROPERTY_ALERT_CORRELATION_ID = "CorrelationId";
    public static final String PROPERTY_ALERT_TIMESTAMP = "Timestamp";
    public static final String PROPERTY_ALERT_FIRSTTIMESTAMP = "FirstTimestamp";
    public static final String PROPERTY_ALERT_LASTTIMESTAMP = "LastTimestamp";
    public static final String PROPERTY_ALERT_CLEARTIMESTAMP = "ClearTimestamp";
    public static final String PROPERTY_ALERT_SOURCE = "Source";
    public static final String PROPERTY_ALERT_NAME = "AlertName";
    public static final String PROPERTY_ALERT_INFO = "Info";
    public static final String PROPERTY_ALERT_INSTANCE = "Instance";
    public static final String PROPERTY_ALERT_SEVERITY = "Severity";
    public static final String PROPERTY_ALERT_PRIORITY = "Priority";
    public static final String PROPERTY_ALERT_TAGS = "Tags";
    public static final String PROPERTY_ALERT_DESCRIPTION = "Description";
    public static final String PROPERTY_ALERT_EVENT_TYPE = "EventType";
    public static final String PROPERTY_ALERT_PROBABLE_CAUSE = "ProbableCause";
    public static final String PROPERTY_ALERT_CURRENT_VALUE = "CurrentValue";
    public static final String PROPERTY_ALERT_URL = "Url";
    public static final String PROPERTY_ALERT_STATUS = "Status";
    public static final String PROPERTY_ALERT_RULE_EXPRESSION = "RuleExpression";
    public static final String PROPERTY_ALERT_RULE_TIME_LIMIT = "RuleTimeLimit";
    private long timeout = 3600000L;
    private long lastCleanup = System.currentTimeMillis();
    private long cleanupTimeout = 5000L;

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        try {
            TransportConnector conn = Transport.createConnector();
            if (null != conn) {
                conn.setReceptionCallback(SMEC_ALERTS, (ReceptionCallback)new AlertReceptionCallback());
            } else {
                LoggerFactory.getLogger(this.getClass()).error("Cannot setup monitoring alert reception: Transport not configured");
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot setup monitoring alert reception: {}", (Object)e.getMessage());
        }
        return null;
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
    }

    public boolean isValid() {
        return true;
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.DYNAMIC;
    }

    private void handleNew(Alert data) {
        try {
            Aas aas = AasPartRegistry.retrieveIipAas();
            AuthenticationDescriptor aDesc = this.getSubmodelAuthentication();
            Submodel.SubmodelBuilder smBuilder = AasPartRegistry.createSubmodelBuilderRbac((Aas)aas, (String)SUBMODEL_MONITORING);
            SubmodelElementList.SubmodelElementListBuilder smcBuilder = smBuilder.createSubmodelElementListBuilder(SMEC_ALERTS);
            SubmodelElementList.SubmodelElementListBuilder entryBuilder = smBuilder.createSubmodelElementListBuilder(AasUtils.fixId((String)("Alert_" + data.getTimestamp())));
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_UID).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getUid())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_CORRELATION_ID).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getCorrelationId())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_TIMESTAMP).setValue(Type.INTEGER, (Object)data.getTimestamp()).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_FIRSTTIMESTAMP).setValue(Type.INTEGER, (Object)data.getFirstTimestamp()).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_LASTTIMESTAMP).setValue(Type.INTEGER, (Object)data.getLastTimestamp()).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_CLEARTIMESTAMP).setValue(Type.INTEGER, (Object)data.getClearTimestamp()).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_SOURCE).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getSource())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_NAME).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getAlertname())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_INFO).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getInfo())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_INSTANCE).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getInstance())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_SEVERITY).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getSeverity())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_PRIORITY).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getPriority())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_TAGS).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getTags())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_DESCRIPTION).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getDescription())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_EVENT_TYPE).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getEventType())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_PROBABLE_CAUSE).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getProbableCause())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_CURRENT_VALUE).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getCurrentValue())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_URL).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getUrl())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_STATUS).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getStatus())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_RULE_EXPRESSION).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getRuleExpression())).build(aDesc);
            smcBuilder.createPropertyBuilder(PROPERTY_ALERT_RULE_TIME_LIMIT).setValue(Type.STRING, (Object)MonitoringAas.safe(data.getRuleTimeLimit())).build(aDesc);
            entryBuilder.build();
            smcBuilder.build();
            smBuilder.build();
            this.cleanup(aas);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot obtain IIP-Ecosphere platform AAS: {}", (Object)e.getMessage());
        }
    }

    private static String safe(String string) {
        return null == string ? "" : string;
    }

    private void cleanup(Aas aas) {
        long now = System.currentTimeMillis();
        if (now - this.lastCleanup > this.cleanupTimeout) {
            SubmodelElementCollection alerts;
            long timestamp = now - this.timeout;
            Submodel sm = aas.getSubmodel(SUBMODEL_MONITORING);
            if (null != sm && null != (alerts = sm.getSubmodelElementCollection(SMEC_ALERTS))) {
                this.cleanup(alerts, timestamp);
                this.lastCleanup = now;
            }
        }
    }

    private void cleanup(SubmodelElementCollection alerts, long timestamp) {
        ArrayList<SubmodelElement> delete = new ArrayList<SubmodelElement>();
        for (SubmodelElement elt : alerts.elements()) {
            SubmodelElementCollection coll;
            Property prop;
            if (!(elt instanceof SubmodelElementCollection) || null == (prop = (coll = (SubmodelElementCollection)elt).getProperty(PROPERTY_ALERT_TIMESTAMP))) continue;
            try {
                Object val = prop.getValue();
                boolean del = false;
                if (val instanceof Integer) {
                    del = (long)((Integer)val).intValue() < timestamp;
                } else if (val instanceof Long) {
                    boolean bl = del = (Long)val < timestamp;
                }
                if (!del) continue;
                delete.add(elt);
            }
            catch (ExecutionException executionException) {}
        }
        for (SubmodelElement elt : delete) {
            alerts.deleteElement(elt.getIdShort());
        }
    }

    private class AlertReceptionCallback
    implements ReceptionCallback<Alert> {
        private AlertReceptionCallback() {
        }

        public void received(Alert data) {
            new Thread(() -> MonitoringAas.this.handleNew(data)).start();
        }

        public Class<Alert> getType() {
            return Alert.class;
        }
    }
}

