/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.DataMapper;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import de.iip_ecosphere.platform.transport.serialization.GenericJsonSerializer;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;

public class DataMapperTest {
    private static int count = 0;

    private static InputStream createTestInputStream() {
        String input = "{\"myInput1\":{\"value\":\"24\"}}\n{\"myInput2\":{\"intVal\":\"10\", \"text\":\"abc\"}}\n";
        return new ByteArrayInputStream(input.getBytes());
    }

    private static void assertMyInput1(MyInput1 input) {
        Assert.assertNotNull((Object)input);
        System.out.println("Asserting(1): " + String.valueOf(input));
        Assert.assertEquals((long)24L, (long)input.getValue());
        ++count;
    }

    private static void assertMyInput2(MyInput2 input) {
        Assert.assertNotNull((Object)input);
        System.out.println("Asserting(2): " + String.valueOf(input));
        Assert.assertEquals((long)10L, (long)input.getIntVal());
        Assert.assertEquals((Object)"abc", (Object)input.getText());
        ++count;
    }

    @Test
    public void testJsonDataMapper() throws IOException {
        count = 0;
        System.out.println("Specific:");
        Consumer<DataUnit> cons = new Consumer<DataUnit>(){

            @Override
            public void accept(DataUnit unit) {
                System.out.println("Received: " + String.valueOf(unit));
                Assert.assertNotNull((Object)unit);
                if (count == 0) {
                    DataMapperTest.assertMyInput1(unit.getMyInput1());
                    Assert.assertNull((Object)unit.getMyInput2());
                } else if (count == 1) {
                    Assert.assertNull((Object)unit.getMyInput1());
                    DataMapperTest.assertMyInput2(unit.getMyInput2());
                } else {
                    Assert.fail((String)("Unexpected instance " + String.valueOf(unit)));
                }
            }
        };
        DataMapper.mapJsonData((InputStream)DataMapperTest.createTestInputStream(), DataUnit.class, (Consumer)cons);
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
    }

    @Test
    public void testGenericJsonDataMapper() throws IOException {
        count = 0;
        System.out.println("Generic:");
        DataMapper.MappingConsumer mConsumer = new DataMapper.MappingConsumer(DataUnit.class);
        mConsumer.addHandler(MyInput1.class, u -> DataMapperTest.assertMyInput1(u));
        mConsumer.addHandler(MyInput2.class, u -> DataMapperTest.assertMyInput2(u));
        DataMapper.mapJsonData((InputStream)DataMapperTest.createTestInputStream(), DataUnit.class, (Consumer)mConsumer);
        Assert.assertEquals((long)2L, (long)count);
        count = 0;
    }

    @Test
    public void testCreateBaseDataUnitClass() {
        try {
            Class cls = DataMapper.createBaseDataUnitClass(Object.class);
            Object o = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            DataMapper.BaseDataUnitFunctions bdfu = (DataMapper.BaseDataUnitFunctions)o;
            bdfu.set$period(123);
            Assert.assertEquals((long)123L, (long)bdfu.get$period());
            bdfu.set$repeats(2);
            Assert.assertEquals((long)2L, (long)bdfu.get$repeats());
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Assert.fail((String)("Shall not occur: " + e.getMessage()));
        }
    }

    @Test
    public void testBaseDataUnitSerialization() throws IOException {
        SerializerRegistry.registerSerializer((Serializer)new GenericJsonSerializer(DataUnitTest.class));
        Class baseCls = DataMapper.createBaseDataUnitClass(DataUnitTest.class);
        String txt = ((JsonObject)Json.createObjectBuilder().add("value", 126).add("$period", 1).add("$repeats", 5).build()).toString();
        ByteArrayInputStream bais = new ByteArrayInputStream(txt.getBytes());
        IOIterator iter = DataMapper.mapJsonDataToIterator((InputStream)bais, (Class)baseCls);
        Serializer baseSer = SerializerRegistry.getSerializer((Class)baseCls);
        while (iter.hasNext()) {
            DataUnitTest data = (DataUnitTest)iter.next();
            DataMapper.BaseDataUnitFunctions bduf = (DataMapper.BaseDataUnitFunctions)data;
            Assert.assertEquals((long)1L, (long)bduf.get$period());
            Assert.assertEquals((long)5L, (long)bduf.get$repeats());
            Assert.assertEquals((long)126L, (long)data.getValue());
            JsonObject obj = Json.createObject((byte[])this.serialize(data));
            Assert.assertEquals((long)data.getValue(), (long)obj.getInt("value"));
            Assert.assertFalse((boolean)obj.containsKey("$period"));
            Assert.assertFalse((boolean)obj.containsKey("$repeats"));
        }
        DataUnitTest obj = (DataUnitTest)baseSer.from((Object)txt.getBytes());
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((long)126L, (long)obj.getValue());
    }

    protected <T> byte[] serialize(T data) throws IOException {
        Class<?> cls = data.getClass();
        Serializer serializer = SerializerRegistry.getSerializer(cls);
        byte[] result = null != serializer ? (byte[])serializer.to(data) : new byte[]{};
        return result;
    }

    static {
        PluginManager.registerPlugin((PluginSetupDescriptor)CurrentClassloaderPluginSetupDescriptor.INSTANCE);
    }

    public static class MyInput1 {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    public static class MyInput2 {
        private int intVal;
        private String text;

        public int getIntVal() {
            return this.intVal;
        }

        public void setIntVal(int intVal) {
            this.intVal = intVal;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    public static class DataUnit {
        private MyInput1 myInput1;
        private MyInput2 myInput2;

        public MyInput1 getMyInput1() {
            return this.myInput1;
        }

        public void setMyInput1(MyInput1 myInput1) {
            this.myInput1 = myInput1;
        }

        public MyInput2 getMyInput2() {
            return this.myInput2;
        }

        public void setMyInput2(MyInput2 myInput2) {
            this.myInput2 = myInput2;
        }

        public String toString() {
            return StringUtils.toStringShortStyle((Object)this);
        }
    }

    public static class DataUnitTest {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

