/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.CachingStrategy;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.events.ConnectorTriggerQuery;
import de.iip_ecosphere.platform.connectors.events.EventHandlingConnector;
import de.iip_ecosphere.platform.services.environment.DataMapper;
import de.iip_ecosphere.platform.services.environment.MockingConnectorServiceWrapper;
import de.iip_ecosphere.platform.services.environment.MultiConnectorServiceWrapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.testing.DataRecorder;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public class MockingMultiConnectorServiceWrapper
extends MultiConnectorServiceWrapper
implements EventHandlingConnector {
    private Map<Class<?>, ReceptionCallback<?>> callbacks = new HashMap();
    private Map<Class<?>, ReceptionCallback<?>> inputCallbacks = new HashMap();
    private Map<Class<?>, CachingStrategy> cachingStrategies = new HashMap();
    private Map<Class<?>, IOIterator<?>> triggerIterators = new HashMap();
    private Supplier<ConnectorParameter> connParamSupplier;
    private boolean enableNotifications;
    private DataRunnable dataRunnable;
    private DataRecorder recorder;
    private Map<String, Object> storage;
    private int notificationInterval = 0;

    public MockingMultiConnectorServiceWrapper(YamlService yaml, Supplier<ConnectorParameter> connParamSupplier) {
        super(yaml, connParamSupplier);
        this.connParamSupplier = connParamSupplier;
        this.recorder = this.createDataRecorder();
    }

    @Override
    public void addConnector(Connector<?, ?, ?, ?> connector) {
        super.addConnector(connector);
        if (null != connector) {
            CachingStrategy cachingStrategy = CachingStrategy.createInstance((Class)connector.getCachingStrategyCls());
            cachingStrategy.setCacheMode(this.connParamSupplier.get().getCacheMode());
            this.cachingStrategies.put(connector.getConnectorOutputType(), cachingStrategy);
        }
    }

    private String getFileName(Connector<?, ?, ?, ?> connector) {
        Class connectorOutType = connector.getConnectorOutputType();
        return "testData-" + connector.getClass().getSimpleName() + "_" + connectorOutType.getSimpleName() + ".yml";
    }

    protected DataRecorder createDataRecorder() {
        return this.createDataRecorderOrig();
    }

    protected final DataRecorder createDataRecorderOrig() {
        return new DataRecorder(new File("target/recordings/connector-" + this.getId() + "-recorded.txt"), DataRecorder.JSON_FORMATTER);
    }

    @Override
    public <CI> void send(Class<CI> cls, CI data) {
        ReceptionCallback<?> inputCallback = this.inputCallbacks.get(data);
        if (null != inputCallback) {
            inputCallback.received(data);
        }
        this.emitData(data);
    }

    @Override
    public <CO> void setReceptionCallback(ReceptionCallback<CO> callback) {
        this.callbacks.put(callback.getType(), callback);
    }

    protected InputStream getDataStream(String name) {
        InputStream result = this.openDataStream(name);
        if (null == result && name.endsWith(".yml")) {
            String altName = name.substring(0, name.length() - 3) + "json";
            LoggerFactory.getLogger(this.getClass()).info("File {} not found, falling back to : {}", (Object)name, (Object)altName);
            result = this.openDataStream(altName);
        }
        return result;
    }

    protected InputStream openDataStream(String name) {
        InputStream result = ResourceLoader.getResourceAsStream((String)name, (ResourceResolver[])new ResourceResolver[0]);
        if (null == result) {
            result = ResourceLoader.getResourceAsStream((String)("resources/" + name), (ResourceResolver[])new ResourceResolver[0]);
        }
        return result;
    }

    private void startData(Supplier<Boolean> continueFunction) throws IOException {
        for (Connector<?, ?, ?, ?> c : this.getConnectors()) {
            this.startData(c, continueFunction);
        }
    }

    private void startData(Connector<?, ?, ?, ?> connector, Supplier<Boolean> continueFunction) throws IOException {
        String fileName = this.getFileName(connector);
        LoggerFactory.getLogger(this.getClass()).info("Starting data with resource: {}", (Object)fileName);
        ConnectorParameter param = this.connParamSupplier.get();
        IdentityToken tok = param.getIdentityToken("");
        if (null != tok) {
            LoggerFactory.getLogger(this.getClass()).info("Hint: AnyEndpoint has id token: {} with token data {}", (Object)tok.getType(), (Object)(tok.getTokenData() != null && tok.getTokenData().length > 0 ? 1 : 0));
        }
        if (AbstractConnector.useTls((ConnectorParameter)param)) {
            LoggerFactory.getLogger(this.getClass()).info("Hint: Aiming for TLS via identity store key {}", (Object)param.getKeystoreKey());
        }
        this.trigger(connector, connector.getConnectorOutputType(), fileName);
    }

    private <CO> void handleReceived(Class<CO> cls, CO data, int notifInterval) {
        Class<?> dataCls = MockingMultiConnectorServiceWrapper.resolve(data.getClass());
        ReceptionCallback<?> callback = this.callbacks.get(dataCls);
        if (callback != null) {
            boolean send = true;
            CachingStrategy cachingStrategy = this.cachingStrategies.get(dataCls);
            if (null != cachingStrategy) {
                send = cachingStrategy.checkCache(data);
            }
            LoggerFactory.getLogger(MockingConnectorServiceWrapper.class).info("Received {} passing on {}", data, (Object)send);
            if (send && callback != null) {
                callback.received(data);
                if (notifInterval > 0) {
                    TimeUtils.sleep((int)notifInterval);
                }
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).info("No callback for data");
        }
    }

    private void startDataThread() {
        if (null == this.dataRunnable) {
            this.dataRunnable = new DataRunnable();
            new Thread(this.dataRunnable).start();
        }
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        this.doSetState(state);
        if (ServiceState.STARTING == state) {
            if (this.enableNotifications) {
                this.startDataThread();
            }
            this.doSetState(ServiceState.RUNNING);
        } else if (ServiceState.STOPPING == state) {
            if (null != this.dataRunnable) {
                this.dataRunnable.stop();
            }
            this.dataRunnable = null;
            this.callbacks.clear();
            this.doSetState(ServiceState.STOPPED);
            if (null != this.recorder) {
                this.recorder.close();
            }
        }
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
    }

    @Override
    public void update(URI location) throws ExecutionException {
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
    }

    @Override
    public void enablePolling(boolean enablePolling) {
        if (!this.enableNotifications && enablePolling) {
            this.startDataThread();
        }
    }

    @Override
    public void enableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public void emitData(Object data) {
        System.out.println("Connector " + this.getId() + ": " + String.valueOf(data));
        if (null != this.recorder) {
            this.recorder.record("data", data);
        }
    }

    public void setInputCallback(ReceptionCallback<?> inputCallback) {
        this.inputCallbacks.put(inputCallback.getType(), inputCallback);
    }

    public void trigger() {
        this.getConnectors().forEach(c -> this.trigger((Connector<?, ?, ?, ?>)c, c.getConnectorOutputType(), this.getFileName((Connector<?, ?, ?, ?>)c)));
    }

    private <CO> void trigger(Connector<?, ?, ?, ?> connector, Class<CO> connectorOutType, String fileName) {
        Object triggerIterator = this.triggerIterators.get(connectorOutType);
        if (null == triggerIterator) {
            LoggerFactory.getLogger(this.getClass()).info("Opening trigger resource: {}", (Object)fileName);
            try {
                triggerIterator = DataMapper.mapJsonDataToIterator(this.getDataStream(fileName), DataMapper.createBaseDataUnitClass(MockingMultiConnectorServiceWrapper.getActualConnectorOutputType(connectorOutType)));
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("While opening trigger resource {}: {}", (Object)fileName, (Object)e.getMessage());
            }
        }
        if (null != triggerIterator) {
            int period = 0;
            try {
                block4: while (triggerIterator.hasNext()) {
                    Object next = triggerIterator.next();
                    DataMapper.BaseDataUnitFunctions bduf = (DataMapper.BaseDataUnitFunctions)next;
                    boolean endless = bduf.get$repeats() < 0;
                    boolean once = bduf.get$repeats() == 0;
                    for (int count = 0; endless || once || count < bduf.get$repeats(); ++count) {
                        LoggerFactory.getLogger(this.getClass()).info("Ingesting data for {} [endless {}, once {}, count {}]: {}", new Object[]{this.getId(), endless, once, count, next});
                        this.handleReceived(connectorOutType, next, this.notificationInterval);
                        period = bduf.get$period();
                        if (period <= 0) continue;
                        TimeUtils.sleep((int)period);
                        if (!once) continue;
                        continue block4;
                    }
                }
                LoggerFactory.getLogger(this.getClass()).info("Mocking data processed for {}, stopping trigger.", (Object)this.getId());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("While processing trigger on {}: {}", (Object)fileName, (Object)e.getMessage());
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).info("Trigger received but no data. Ignoring");
        }
    }

    public void trigger(ConnectorTriggerQuery query) {
        this.trigger();
    }

    public void setStorageValue(String key, Object value) {
        if (null != key) {
            if (null == this.storage) {
                this.storage = new HashMap<String, Object>();
            }
            this.storage.put(key, value);
        }
    }

    public Object getStorageValue(String key) {
        return null == this.storage || null == key ? null : this.storage.get(key);
    }

    public void setDataTimeDifference(int difference) {
        if (difference >= 0) {
            this.notificationInterval = difference;
        }
    }

    private class DataRunnable
    implements Runnable {
        private boolean cont = true;

        private DataRunnable() {
        }

        @Override
        public void run() {
            try {
                MockingMultiConnectorServiceWrapper.this.startData(() -> this.cont);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MockingConnectorServiceWrapper.class).info("Starting data: {}", (Object)e.getMessage());
            }
        }

        public void stop() {
            this.cont = false;
        }
    }
}

