/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.CounterRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.GaugeRepresentation;
import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.TimerRepresentation;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import de.iip_ecosphere.platform.support.metrics.Tag;
import de.iip_ecosphere.platform.support.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class MeterRepresentation
implements Meter {
    private static final String NON_VALID_JSON = "JsonObject does not map a valid Meter!";
    private Meter.Id id;

    protected MeterRepresentation(JsonObject object, Meter.Type type, String ... tags) {
        if (object == null) {
            throw new IllegalArgumentException("The Object is null!");
        }
        try {
            String baseUnit = object.isNull("baseUnit") ? null : object.getString("baseUnit");
            String description = object.isNull("description") ? null : object.getString("description");
            this.id = MetricsFactory.buildId((String)object.getString("name"), MeterRepresentation.extractTagsMap(tags), (String)baseUnit, (String)description, (Meter.Type)type);
        }
        catch (ClassCastException | NullPointerException ex) {
            throw new IllegalArgumentException(NON_VALID_JSON, ex);
        }
    }

    protected MeterRepresentation(String name, Meter.Type type) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or null");
        }
        this.id = MetricsFactory.buildId((String)name, new ArrayList(), null, null, (Meter.Type)type);
    }

    private static List<Tag> extractTagsMap(String ... tags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        try {
            for (String tag : tags) {
                String[] aux = tag.split(":");
                if (aux.length == 2 && aux[0].length() > 0 && aux[1].length() > 0) {
                    tagList.add(MetricsFactory.buildImmutableTag((String)aux[0], (String)aux[1]));
                    continue;
                }
                LoggerFactory.getLogger(MeterRepresentation.class).warn("'{}' does not parse to a vaild meter tag. Ignoring.", (Object)tag);
            }
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw new IllegalArgumentException(NON_VALID_JSON, aiobe);
        }
        return tagList;
    }

    public Meter.Id getId() {
        return this.id;
    }

    public abstract Iterable<Measurement> measure();

    public abstract JsonObject getUpdater();

    public static Meter parseMeter(String json, String ... tags) {
        try {
            return MeterRepresentation.parseMeter(Json.createObject((String)json), tags);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(MeterRepresentation.class).info("Cannot parse meter JSON '{}' : {}", (Object)json, (Object)e.getMessage());
            return null;
        }
    }

    public static Meter parseMeterQuiet(String json, String ... tags) {
        try {
            return MeterRepresentation.parseMeter(Json.createObject((String)json), tags);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Meter parseMeter(JsonObject object, String ... tags) {
        JsonArray tgs;
        Timer result = null;
        boolean valueFound = false;
        boolean countFound = false;
        boolean totalTimeFound = false;
        JsonArray measurements = object.getJsonArray("measurements");
        if (null != measurements) {
            for (int i = 0; i < measurements.size(); ++i) {
                JsonObject measurement = measurements.getJsonObject(i);
                if (null == measurement) continue;
                String statistics = measurement.getString("statistic");
                valueFound |= Statistic.VALUE.name().equals(statistics);
                countFound |= Statistic.COUNT.name().equals(statistics);
                totalTimeFound |= Statistic.TOTAL_TIME.name().equals(statistics);
            }
        }
        if (null != (tgs = object.getJsonArray("availableTags"))) {
            int i;
            String[] tmp = new String[tags.length + tgs.size()];
            int pos = 0;
            for (i = 0; i < tags.length; ++i) {
                tmp[pos++] = tags[i];
            }
            for (i = 0; i < tgs.size(); ++i) {
                tmp[pos++] = tgs.getString(i);
            }
            tags = tmp;
        }
        if (totalTimeFound && countFound) {
            result = TimerRepresentation.parseTimer(object, tags);
        } else if (countFound) {
            result = CounterRepresentation.parseCounter(object, tags);
        } else if (valueFound) {
            result = GaugeRepresentation.parseGauge(object, tags);
        }
        return result;
    }

    public String getName() {
        return this.id.getName();
    }
}

