/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.services.environment.services.Sender;
import de.iip_ecosphere.platform.services.environment.services.TransportConverter;
import de.iip_ecosphere.platform.services.environment.services.WsTransportConverterFactory;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.serialization.GenericJsonToStringTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Function;

public abstract class TransportConverterFactory {
    public static final String GATEWAY_PORT_KEY = "Transport-gatewayPort";
    private static TransportConverterFactory instance = WsTransportConverterFactory.INSTANCE;

    public static TransportConverterFactory getInstance() {
        return instance;
    }

    public final <T> Sender<T> createSender(AasPartRegistry.AasSetup aas, TransportSetup transport, String path, TypeTranslator<T, String> translator, Class<T> cls) {
        return this.createSender(this.validateGatewayEndpoint(this.getGatewayEndpoint(aas, transport, path)), translator, cls);
    }

    public final <T> Sender<T> createSender(Endpoint endpoint, TypeTranslator<T, String> translator, Class<T> cls) {
        return this.createSenderImpl(endpoint, TransportConverterFactory.ensureTranslator(translator, cls), cls);
    }

    protected abstract <T> Sender<T> createSenderImpl(Endpoint var1, TypeTranslator<T, String> var2, Class<T> var3);

    public final <T> TransportConverter.Watcher<T> createWatcher(AasPartRegistry.AasSetup aas, TransportSetup transport, String path, TypeTranslator<T, String> translator, Class<T> cls, int period) {
        return this.createWatcher(this.validateGatewayEndpoint(this.getGatewayEndpoint(aas, transport, path)), translator, cls, period);
    }

    public final <T> TransportConverter.Watcher<T> createWatcher(Endpoint endpoint, TypeTranslator<T, String> translator, Class<T> cls, int period) {
        return this.createWatcherImpl(endpoint, TransportConverterFactory.ensureTranslator(translator, cls), cls, period);
    }

    protected abstract <T> TransportConverter.Watcher<T> createWatcherImpl(Endpoint var1, TypeTranslator<T, String> var2, Class<T> var3, int var4);

    public final <T> TransportConverter<T> createConverter(AasPartRegistry.AasSetup aas, TransportSetup transport, String transportStream, String path, TypeTranslator<T, String> translator, Class<T> cls) {
        return this.createConverter(this.validateGatewayEndpoint(this.getGatewayEndpoint(aas, transport, path)), transportStream, translator, cls);
    }

    public final <T> TransportConverter<T> createConverter(Endpoint endpoint, String transportStream, TypeTranslator<T, String> translator, Class<T> cls) {
        return this.createConverterImpl(endpoint, transportStream, TransportConverterFactory.ensureTranslator(translator, cls), cls);
    }

    public abstract <T> TransportConverter<T> createConverterImpl(Endpoint var1, String var2, TypeTranslator<T, String> var3, Class<T> var4);

    public static <T> TypeTranslator<T, String> ensureTranslator(TypeTranslator<T, String> translator, Class<T> cls) {
        if (null == translator) {
            translator = new GenericJsonToStringTranslator(cls);
        }
        return translator;
    }

    protected <R> R createWithUri(AasPartRegistry.AasSetup aas, TransportSetup transport, String path, Function<URI, R> creator) {
        return TransportConverterFactory.createWithUri(this.validateGatewayEndpoint(this.getGatewayEndpoint(aas, transport, path)), creator);
    }

    protected static <R> R createWithUri(Endpoint endpoint, Function<URI, R> creator) {
        String uri = endpoint.toUri();
        try {
            return creator.apply(new URI(uri));
        }
        catch (URISyntaxException e) {
            LoggerFactory.getLogger(TransportConverterFactory.class).error("URI syntax error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public final Server createServer(AasPartRegistry.AasSetup aas, TransportSetup transport) {
        Endpoint ep = this.getGatewayEndpoint(aas, transport, "");
        int port = ep.getPort();
        if (port <= 0) {
            ep = new Endpoint(ep.getSchema(), ep.getHost(), NetUtils.getEphemeralPort(), ep.getEndpoint());
            transport.setGatewayPort(ep.getPort());
            NetworkManagerFactory.getInstance().reservePort(GATEWAY_PORT_KEY, (ServerAddress)ep);
        }
        return this.createServer((ServerAddress)ep);
    }

    public abstract Server createServer(ServerAddress var1);

    public abstract Endpoint getGatewayEndpoint(AasPartRegistry.AasSetup var1, TransportSetup var2, String var3);

    public Endpoint validateGatewayEndpoint(Endpoint endpoint) {
        ManagedServerAddress adr = NetworkManagerFactory.getInstance().getPort(GATEWAY_PORT_KEY);
        if (null != adr) {
            endpoint = new Endpoint(adr.getSchema(), adr.getHost(), adr.getPort(), endpoint.getEndpoint());
        }
        return endpoint;
    }
}

