/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.testing;

import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.IOException;
import java.util.function.Supplier;

public class TestBroker
implements Starter.Plugin {
    public static TransportSetup createSetup(String[] args) {
        TransportSetup setup = null;
        String host = CmdLine.getArg((String[])args, (String)"test.host", null);
        int port = CmdLine.getIntArg((String[])args, (String)"test.port", (int)-1);
        String authKey = CmdLine.getArg((String[])args, (String)"test.authKey", null);
        if (host != null && port > 0) {
            setup = new TransportSetup();
            setup.setHost(host);
            setup.setPort(port);
            if (null != authKey) {
                setup.setAuthenticationKey(authKey);
            }
        }
        return setup;
    }

    public static ReceptionCallback<String> createStringReceptionCallback() {
        ReceptionCallback<String> rcp = new ReceptionCallback<String>(){

            public void received(String data) {
                System.out.println("Received: " + data);
            }

            public Class<String> getType() {
                return String.class;
            }
        };
        return rcp;
    }

    @Override
    public void run(String[] args) {
        TransportSetup setup = TestBroker.createSetup(args);
        String channel = CmdLine.getArg((String[])args, (String)"test.channel", null);
        if (setup != null && channel != null) {
            try {
                Supplier old = Transport.setTransportSetup(() -> setup);
                ReceptionCallback<String> rcp = TestBroker.createStringReceptionCallback();
                TransportConnector conn = Transport.createConnector();
                conn.setReceptionCallback(channel, rcp);
                conn.asyncSend(channel, (Object)"Async Testdata");
                conn.syncSend(channel, (Object)"Sync Testdata");
                conn.detachReceptionCallback(channel, rcp);
                Transport.releaseConnector((boolean)false);
                Transport.setTransportSetup((Supplier)old);
            }
            catch (IOException e) {
                System.out.println("Failed: " + e.getMessage());
            }
        } else {
            System.out.println("Insufficient parameter: " + this.getHelp(""));
        }
    }

    @Override
    public String getHelp(String indent) {
        return "tests the transport broker functionality: --test.host=<host> --test.port=<port> --test.authKey=<authKey> --test.channel=<channel>";
    }
}

