/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.services.environment.AasCreator;

public abstract class AbstractEnvironmentTest {
    public static void testAas(SetupSpec spec, Service expected) throws IOException, ExecutionException {
        AasFactory factory = AasFactory.getInstance();
        Aas aas = factory.obtainRegistry(spec).retrieveAas("urn:::AAS:::AiTestAas#");
        Assert.assertNotNull((String)"Aas urn:::AAS:::AiTestAas# shall be there", (Object)aas);
        Submodel submodel = aas.getSubmodel("AiService");
        Assert.assertNotNull((String)"Submodel AiService shall be there", (Object)submodel);
        AbstractEnvironmentTest.assertProperty(submodel, "id", o -> AbstractEnvironmentTest.checkString(o, expected.getId()));
        AbstractEnvironmentTest.assertProperty(submodel, "name", o -> AbstractEnvironmentTest.checkString(o, expected.getName()));
        AbstractEnvironmentTest.assertProperty(submodel, "description", o -> AbstractEnvironmentTest.checkString(o, expected.getDescription()));
        AbstractEnvironmentTest.assertProperty(submodel, "version", o -> AbstractEnvironmentTest.checkVersion(o, expected.getVersion()));
        AbstractEnvironmentTest.assertOperation(submodel, "getState", o -> AbstractEnvironmentTest.checkStateString(o, expected.getState()), null, new Object[0]);
        AbstractEnvironmentTest.assertProperty(submodel, "kind", o -> AbstractEnvironmentTest.checkKindString(o, expected.getKind()));
        AbstractEnvironmentTest.assertProperty(submodel, "deployable", o -> AbstractEnvironmentTest.checkBoolean(o, expected.isDeployable()));
        AbstractEnvironmentTest.assertOperation(submodel, "setState", null, null, ServiceState.STARTING.name());
        AbstractEnvironmentTest.assertOperation(submodel, "setState", null, null, ServiceState.RUNNING.name());
        AbstractEnvironmentTest.assertOperation(submodel, "getState", o -> AbstractEnvironmentTest.checkStateString(o, ServiceState.RUNNING), null, new Object[0]);
        AbstractEnvironmentTest.assertOperation(submodel, "passivate", null, null, new Object[0]);
        AbstractEnvironmentTest.assertOperation(submodel, "getState", o -> AbstractEnvironmentTest.checkStateString(o, ServiceState.PASSIVATED), null, new Object[0]);
        AbstractEnvironmentTest.assertOperation(submodel, "activate", null, null, new Object[0]);
        AbstractEnvironmentTest.assertOperation(submodel, "getState", o -> AbstractEnvironmentTest.checkStateString(o, ServiceState.RUNNING), null, new Object[0]);
        AbstractEnvironmentTest.assertOperation(submodel, "migrate", null, e -> true, "myResource");
        AbstractEnvironmentTest.assertOperation(submodel, "switchTo", null, e -> true, "otherService");
        AbstractEnvironmentTest.assertOperation(submodel, "update", null, e -> true, "http://wherever.com/service/0.1.0");
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("name1", "TEST");
        values.put("name2", 25);
        AbstractEnvironmentTest.assertOperation(submodel, "reconfigure", null, e -> true, values);
    }

    public static void testAasResult(AasCreator.AasResult result, Service expected) {
        if (null != result && result.getStub() != null) {
            ServiceStub stub = result.getStub();
            AbstractEnvironmentTest.checkString(stub.getId(), expected.getId());
            AbstractEnvironmentTest.checkString(stub.getName(), expected.getName());
            AbstractEnvironmentTest.checkString(stub.getDescription(), expected.getDescription());
            AbstractEnvironmentTest.checkVersion(stub.getVersion(), expected.getVersion());
            AbstractEnvironmentTest.checkStateString(stub.getState(), expected.getState());
            AbstractEnvironmentTest.checkKindString(stub.getKind(), expected.getKind());
            AbstractEnvironmentTest.checkBoolean(stub.isDeployable(), expected.isDeployable());
            AbstractEnvironmentTest.checkStateString(stub.getState().name(), expected.getState());
            try {
                stub.migrate("myResource");
                Assert.fail((String)"Shall throw exception");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            try {
                stub.switchTo("otherService");
                Assert.fail((String)"Shall throw exception");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            try {
                stub.update(new URI("https://here.de"));
                Assert.fail((String)"Shall throw exception");
            }
            catch (ExecutionException executionException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            try {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("name1", "{}");
                values.put("name2", "{'test' : 25}");
                stub.reconfigure(values);
                Assert.fail((String)"Shall throw exception");
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private static void assertProperty(Submodel submodel, String propertyName, Function<Object, Boolean> cond) throws ExecutionException {
        Property prop = submodel.getProperty(propertyName);
        Assert.assertNotNull((String)("Property " + propertyName + " not found"), (Object)prop);
        if (null == cond) {
            Assert.assertNull((String)("Value of property " + propertyName + " shall be null"), (Object)prop.getValue());
        } else {
            Assert.assertTrue((String)("Condition on property " + propertyName + " does not hold"), (boolean)cond.apply(prop.getValue()));
        }
    }

    private static void assertOperation(Submodel submodel, String operationName, Function<String, Boolean> cond, Function<Exception, Boolean> exc, Object ... args) throws ExecutionException {
        Operation op = submodel.getOperation(operationName);
        Assert.assertNotNull((String)("Operation " + operationName + " not found"), (Object)op);
        try {
            String result = JsonResultWrapper.fromJson((Object)op.invoke(args));
            if (null != exc) {
                Assert.fail((String)("Exception expected when calling " + operationName));
            }
            if (null != cond) {
                Assert.assertTrue((String)("Condition on result of " + operationName + " does not hold"), (boolean)cond.apply(result));
            }
        }
        catch (ExecutionException e) {
            if (null != exc) {
                Assert.assertTrue((String)("Condition on exception of " + operationName + " does not hold"), (boolean)exc.apply(e));
            }
            throw e;
        }
    }

    private static boolean checkNonEmptyString(Object obj) {
        return obj instanceof String && ((String)obj).length() > 0;
    }

    private static boolean checkEmptyString(Object obj) {
        return obj instanceof String && ((String)obj).length() == 0;
    }

    private static boolean checkString(Object obj, String expected) {
        if (null == expected) {
            return obj == null;
        }
        return AbstractEnvironmentTest.checkNonEmptyString(obj) && expected.equals(obj);
    }

    private static boolean checkVersion(Object obj, Version expected) {
        if (null == expected) {
            return obj == null;
        }
        if (obj instanceof String) {
            return expected.toString().equals(obj);
        }
        if (obj instanceof Version) {
            return expected.equals(obj);
        }
        return false;
    }

    private static boolean checkBoolean(Object obj) {
        return obj instanceof Boolean;
    }

    private static boolean checkBoolean(Object obj, boolean expectedValue) {
        return AbstractEnvironmentTest.checkBoolean(obj) && (Boolean)obj == expectedValue;
    }

    private static boolean checkStateString(Object obj) {
        return AbstractEnvironmentTest.checkStateString(obj, null);
    }

    private static boolean checkStateString(Object obj, ServiceState expectedValue) {
        boolean ok = AbstractEnvironmentTest.checkNonEmptyString(obj);
        if (ok) {
            try {
                ServiceState state = ServiceState.valueOf((String)obj.toString());
                if (null != expectedValue) {
                    ok = expectedValue.equals((Object)state);
                }
            }
            catch (IllegalArgumentException e) {
                ok = false;
            }
        }
        return ok;
    }

    private static boolean checkKindString(Object obj, ServiceKind expectedValue) {
        boolean ok = AbstractEnvironmentTest.checkNonEmptyString(obj);
        if (ok) {
            try {
                ServiceKind kind = ServiceKind.valueOf((String)obj.toString());
                if (null != expectedValue) {
                    ok = expectedValue.equals((Object)kind);
                }
            }
            catch (IllegalArgumentException e) {
                ok = false;
            }
        }
        return ok;
    }
}

